/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.types;

import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.v1.Value;

public enum TypeConstructor {
    ANY{

        @Override
        public boolean covers(Value value) {
            return !value.isNull();
        }
    }
    ,
    BOOLEAN,
    BYTES,
    STRING,
    NUMBER{

        @Override
        public boolean covers(Value value) {
            TypeConstructor valueType = TypeConstructor.typeConstructorOf(value);
            return valueType == this || valueType == INTEGER || valueType == FLOAT;
        }
    }
    ,
    INTEGER,
    FLOAT,
    LIST,
    MAP{

        @Override
        public boolean covers(Value value) {
            TypeConstructor valueType = TypeConstructor.typeConstructorOf(value);
            return valueType == MAP || valueType == NODE || valueType == RELATIONSHIP;
        }
    }
    ,
    NODE,
    RELATIONSHIP,
    PATH,
    POINT,
    DATE,
    TIME,
    LOCAL_TIME,
    LOCAL_DATE_TIME,
    DATE_TIME,
    DURATION,
    NULL;


    private static TypeConstructor typeConstructorOf(Value value) {
        return ((InternalValue)value).typeConstructor();
    }

    public boolean covers(Value value) {
        return this == TypeConstructor.typeConstructorOf(value);
    }
}

