/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import java.util.Objects;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ByteBufInput;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderException;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class InboundMessageHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ByteBufInput input = new ByteBufInput();
    private final MessageFormat.Reader reader;
    private final Logging logging;
    private InboundMessageDispatcher messageDispatcher;
    private Logger log;

    public InboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this.reader = messageFormat.newReader(this.input);
        this.logging = logging;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(ctx.channel()));
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
        this.log = null;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        if (this.messageDispatcher.fatalErrorOccurred()) {
            this.log.warn("Message ignored because of the previous fatal error. Channel will be closed. Message:\n%s", ByteBufUtil.hexDump(msg));
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("S: %s", ByteBufUtil.hexDump(msg));
        }
        this.input.start(msg);
        try {
            this.reader.read(this.messageDispatcher);
        }
        catch (Throwable error) {
            throw new DecoderException("Failed to read inbound message:\n" + ByteBufUtil.hexDump(msg) + "\n", error);
        }
        finally {
            this.input.stop();
        }
    }
}

