/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.time.Duration;
import java.util.Objects;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.metrics.ConnectionMetricsListener;
import org.neo4j.driver.internal.metrics.InternalHistogram;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.spi.ConnectionMetrics;
import org.neo4j.driver.internal.metrics.spi.Histogram;

public class InternalConnectionMetrics
implements ConnectionMetrics,
ConnectionMetricsListener {
    private final InternalHistogram connHistogram;
    private final InternalHistogram inUseHistogram;
    private final BoltServerAddress serverAddress;

    public InternalConnectionMetrics(BoltServerAddress serverAddress, int connectionTimeoutMillis) {
        Objects.requireNonNull(serverAddress);
        this.serverAddress = serverAddress;
        this.connHistogram = new InternalHistogram(Duration.ofMillis(connectionTimeoutMillis).toNanos());
        this.inUseHistogram = new InternalHistogram();
    }

    @Override
    public String uniqueName() {
        return this.serverAddress.toString();
    }

    @Override
    public Histogram connectionTimeHistogram() {
        return this.connHistogram.snapshot();
    }

    @Override
    public Histogram inUseTimeHistogram() {
        return this.inUseHistogram.snapshot();
    }

    @Override
    public void beforeCreating(ListenerEvent connEvent) {
        connEvent.start();
    }

    @Override
    public void afterCreated(ListenerEvent connEvent) {
        long elapsed = connEvent.elapsed();
        this.connHistogram.recordValue(elapsed);
    }

    @Override
    public void acquiredOrCreated(ListenerEvent inUseEvent) {
        inUseEvent.start();
    }

    @Override
    public void released(ListenerEvent inUseEvent) {
        long elapsed = inUseEvent.elapsed();
        this.inUseHistogram.recordValue(elapsed);
    }

    public String toString() {
        return String.format("connectionTimeHistogram=%s, inUseTimeHistogram=%s", this.connectionTimeHistogram(), this.inUseTimeHistogram());
    }
}

