/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.async.QueryRunner;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;

public class RoutingProcedureRunner {
    static final String GET_SERVERS = "dbms.cluster.routing.getServers";
    static final String GET_ROUTING_TABLE_PARAM = "context";
    static final String GET_ROUTING_TABLE = "dbms.cluster.routing.getRoutingTable({context})";
    private final RoutingContext context;

    public RoutingProcedureRunner(RoutingContext context) {
        this.context = context;
    }

    public CompletionStage<RoutingProcedureResponse> run(CompletionStage<Connection> connectionStage) {
        return connectionStage.thenCompose(connection -> {
            Statement procedure = this.procedureStatement(connection.serverVersion());
            return this.runProcedure((Connection)connection, procedure).thenCompose(records -> this.releaseConnection((Connection)connection, (List<Record>)records)).handle((records, error) -> this.processProcedureResponse(procedure, (List<Record>)records, (Throwable)error));
        });
    }

    CompletionStage<List<Record>> runProcedure(Connection connection, Statement procedure) {
        return QueryRunner.runInSession(connection, procedure, true).thenCompose(StatementResultCursor::listAsync);
    }

    private Statement procedureStatement(ServerVersion serverVersion) {
        if (serverVersion.greaterThanOrEqual(ServerVersion.v3_2_0)) {
            return new Statement("CALL dbms.cluster.routing.getRoutingTable({context})", Values.parameters(GET_ROUTING_TABLE_PARAM, this.context.asMap()));
        }
        return new Statement("CALL dbms.cluster.routing.getServers");
    }

    private CompletionStage<List<Record>> releaseConnection(Connection connection, List<Record> records) {
        return connection.release().thenApply(ignore -> records);
    }

    private RoutingProcedureResponse processProcedureResponse(Statement procedure, List<Record> records, Throwable error) {
        Throwable cause = Futures.completionExceptionCause(error);
        if (cause != null) {
            return this.handleError(procedure, cause);
        }
        return new RoutingProcedureResponse(procedure, records);
    }

    private RoutingProcedureResponse handleError(Statement procedure, Throwable error) {
        if (error instanceof ClientException) {
            return new RoutingProcedureResponse(procedure, error);
        }
        throw new CompletionException(error);
    }
}

