/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.neo4j.driver.v1.types.IsoDuration;

public class InternalIsoDuration
implements IsoDuration {
    private static final List<TemporalUnit> SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS));
    private final long months;
    private final long days;
    private final long seconds;
    private final int nanoseconds;

    public InternalIsoDuration(Period period) {
        this(period.toTotalMonths(), period.getDays(), 0L, 0);
    }

    public InternalIsoDuration(Duration duration) {
        this(0L, 0L, duration.getSeconds(), duration.getNano());
    }

    public InternalIsoDuration(long months, long days, long seconds, int nanoseconds) {
        this.months = months;
        this.days = days;
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    public InternalIsoDuration(Period period, Duration duration) {
        this(period.toTotalMonths(), period.getDays(), duration.getSeconds(), duration.getNano());
    }

    @Override
    public long months() {
        return this.months;
    }

    @Override
    public long days() {
        return this.days;
    }

    @Override
    public long seconds() {
        return this.seconds;
    }

    @Override
    public int nanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (unit == ChronoUnit.DAYS) {
            return this.days;
        }
        if (unit == ChronoUnit.SECONDS) {
            return this.seconds;
        }
        if (unit == ChronoUnit.NANOS) {
            return this.nanoseconds;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.plus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.plus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.minus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.minus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalIsoDuration that = (InternalIsoDuration)o;
        return this.months == that.months && this.days == that.days && this.seconds == that.seconds && this.nanoseconds == that.nanoseconds;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.seconds, this.nanoseconds);
    }

    public String toString() {
        return String.format("P%sM%sDT%s.%sS", this.months, this.days, this.seconds, String.format("%09d", this.nanoseconds));
    }
}

