/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.neo4j.driver.v1.types.IsoDuration;

public class InternalIsoDuration
implements IsoDuration {
    private static final List<TemporalUnit> SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS));
    private static final InternalIsoDuration ZERO = new InternalIsoDuration(0L, 0L, 0L, 0);
    public static final long NANOS_PER_SECOND = 1000000000L;
    private final long months;
    private final long days;
    private final long seconds;
    private final int nanoseconds;

    public InternalIsoDuration(Period period) {
        this(period.toTotalMonths(), period.getDays(), 0L, 0);
    }

    public InternalIsoDuration(Duration duration) {
        this(0L, 0L, duration.getSeconds(), duration.getNano());
    }

    public InternalIsoDuration(long months, long days, long seconds, int nanoseconds) {
        this.months = months;
        this.days = days;
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    public InternalIsoDuration(Period period, Duration duration) {
        this(period.toTotalMonths(), period.getDays(), duration.getSeconds(), duration.getNano());
    }

    @Override
    public long months() {
        return this.months;
    }

    @Override
    public long days() {
        return this.days;
    }

    @Override
    public long seconds() {
        return this.seconds;
    }

    @Override
    public int nanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (unit == ChronoUnit.DAYS) {
            return this.days;
        }
        if (unit == ChronoUnit.SECONDS) {
            return this.seconds;
        }
        if (unit == ChronoUnit.NANOS) {
            return this.nanoseconds;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.plus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.plus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.minus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.minus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalIsoDuration that = (InternalIsoDuration)o;
        return this.months == that.months && this.days == that.days && this.seconds == that.seconds && this.nanoseconds == that.nanoseconds;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.seconds, this.nanoseconds);
    }

    public String toString() {
        if (this.equals(ZERO)) {
            return "PT0S";
        }
        StringBuilder str = new StringBuilder().append("P");
        InternalIsoDuration.append(str, this.months / 12L, 'Y');
        InternalIsoDuration.append(str, this.months % 12L, 'M');
        InternalIsoDuration.append(str, this.days / 7L, 'W');
        InternalIsoDuration.append(str, this.days % 7L, 'D');
        if (this.seconds != 0L || this.nanoseconds != 0) {
            str.append('T');
            long s = this.seconds % 3600L;
            InternalIsoDuration.append(str, this.seconds / 3600L, 'H');
            InternalIsoDuration.append(str, s / 60L, 'M');
            if ((s %= 60L) != 0L) {
                str.append(s);
                if (this.nanoseconds != 0) {
                    this.nanos(str);
                }
                str.append('S');
            } else if (this.nanoseconds != 0) {
                if (this.nanoseconds < 0) {
                    str.append('-');
                }
                str.append('0');
                this.nanos(str);
                str.append('S');
            }
        }
        if (str.length() == 1) {
            str.append("T0S");
        }
        return str.toString();
    }

    private static void append(StringBuilder str, long quantity, char unit) {
        if (quantity != 0L) {
            str.append(quantity).append(unit);
        }
    }

    private void nanos(StringBuilder str) {
        str.append('.');
        int mod = 1000000000;
        for (int n = this.nanoseconds < 0 ? -this.nanoseconds : this.nanoseconds; mod > 1 && n > 0; n %= mod) {
            str.append(n / (mod /= 10));
        }
    }
}

