/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.neo4j.driver.internal.InternalPoint2D;
import org.neo4j.driver.internal.InternalPoint3D;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV1;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.types.IsoDuration;
import org.neo4j.driver.v1.types.Point;

public class PackStreamMessageFormatV2
extends PackStreamMessageFormatV1 {
    private static final byte DATE = 68;
    private static final int DATE_STRUCT_SIZE = 1;
    private static final byte TIME = 84;
    private static final int TIME_STRUCT_SIZE = 2;
    private static final byte LOCAL_TIME = 116;
    private static final int LOCAL_TIME_STRUCT_SIZE = 1;
    private static final byte LOCAL_DATE_TIME = 100;
    private static final int LOCAL_DATE_TIME_STRUCT_SIZE = 2;
    private static final byte DATE_TIME_WITH_ZONE_OFFSET = 70;
    private static final byte DATE_TIME_WITH_ZONE_ID = 102;
    private static final int DATE_TIME_STRUCT_SIZE = 3;
    private static final byte DURATION = 69;
    private static final int DURATION_TIME_STRUCT_SIZE = 4;
    private static final byte POINT_2D_STRUCT_TYPE = 88;
    private static final int POINT_2D_STRUCT_SIZE = 3;
    private static final byte POINT_3D_STRUCT_TYPE = 89;
    private static final int POINT_3D_STRUCT_SIZE = 4;

    @Override
    public MessageFormat.Writer newWriter(PackOutput output, boolean byteArraySupportEnabled) {
        if (!byteArraySupportEnabled) {
            throw new IllegalArgumentException("Bolt V2 should support byte arrays");
        }
        return new WriterV2(output);
    }

    @Override
    public MessageFormat.Reader newReader(PackInput input) {
        return new ReaderV2(input);
    }

    private static class ReaderV2
    extends PackStreamMessageFormatV1.ReaderV1 {
        ReaderV2(PackInput input) {
            super(input);
        }

        @Override
        Value unpackStruct(long size, byte type) throws IOException {
            switch (type) {
                case 68: {
                    this.ensureCorrectStructSize(TypeConstructor.DATE, 1, size);
                    return this.unpackDate();
                }
                case 84: {
                    this.ensureCorrectStructSize(TypeConstructor.TIME, 2, size);
                    return this.unpackTime();
                }
                case 116: {
                    this.ensureCorrectStructSize(TypeConstructor.LOCAL_TIME, 1, size);
                    return this.unpackLocalTime();
                }
                case 100: {
                    this.ensureCorrectStructSize(TypeConstructor.LOCAL_DATE_TIME, 2, size);
                    return this.unpackLocalDateTime();
                }
                case 70: {
                    this.ensureCorrectStructSize(TypeConstructor.DATE_TIME, 3, size);
                    return this.unpackDateTimeWithZoneOffset();
                }
                case 102: {
                    this.ensureCorrectStructSize(TypeConstructor.DATE_TIME, 3, size);
                    return this.unpackDateTimeWithZoneId();
                }
                case 69: {
                    this.ensureCorrectStructSize(TypeConstructor.DURATION, 4, size);
                    return this.unpackDuration();
                }
                case 88: {
                    this.ensureCorrectStructSize(TypeConstructor.POINT, 3, size);
                    return this.unpackPoint2D();
                }
                case 89: {
                    this.ensureCorrectStructSize(TypeConstructor.POINT, 4, size);
                    return this.unpackPoint3D();
                }
            }
            return super.unpackStruct(size, type);
        }

        private Value unpackDate() throws IOException {
            long epochDay = this.unpacker.unpackLong();
            return Values.value(LocalDate.ofEpochDay(epochDay));
        }

        private Value unpackTime() throws IOException {
            long nanoOfDayLocal = this.unpacker.unpackLong();
            int offsetSeconds = Math.toIntExact(this.unpacker.unpackLong());
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDayLocal);
            ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSeconds);
            return Values.value(OffsetTime.of(localTime, offset));
        }

        private Value unpackLocalTime() throws IOException {
            long nanoOfDayLocal = this.unpacker.unpackLong();
            return Values.value(LocalTime.ofNanoOfDay(nanoOfDayLocal));
        }

        private Value unpackLocalDateTime() throws IOException {
            long epochSecondUtc = this.unpacker.unpackLong();
            int nano = Math.toIntExact(this.unpacker.unpackLong());
            return Values.value(LocalDateTime.ofEpochSecond(epochSecondUtc, nano, ZoneOffset.UTC));
        }

        private Value unpackDateTimeWithZoneOffset() throws IOException {
            long epochSecondLocal = this.unpacker.unpackLong();
            int nano = Math.toIntExact(this.unpacker.unpackLong());
            int offsetSeconds = Math.toIntExact(this.unpacker.unpackLong());
            return Values.value(ReaderV2.newZonedDateTime(epochSecondLocal, nano, ZoneOffset.ofTotalSeconds(offsetSeconds)));
        }

        private Value unpackDateTimeWithZoneId() throws IOException {
            long epochSecondLocal = this.unpacker.unpackLong();
            int nano = Math.toIntExact(this.unpacker.unpackLong());
            String zoneIdString = this.unpacker.unpackString();
            return Values.value(ReaderV2.newZonedDateTime(epochSecondLocal, nano, ZoneId.of(zoneIdString)));
        }

        private Value unpackDuration() throws IOException {
            long months = this.unpacker.unpackLong();
            long days = this.unpacker.unpackLong();
            long seconds = this.unpacker.unpackLong();
            long nanoseconds = this.unpacker.unpackLong();
            return Values.isoDuration(months, days, seconds, nanoseconds);
        }

        private Value unpackPoint2D() throws IOException {
            int srid = Math.toIntExact(this.unpacker.unpackLong());
            double x = this.unpacker.unpackDouble();
            double y = this.unpacker.unpackDouble();
            return Values.point(srid, x, y);
        }

        private Value unpackPoint3D() throws IOException {
            int srid = Math.toIntExact(this.unpacker.unpackLong());
            double x = this.unpacker.unpackDouble();
            double y = this.unpacker.unpackDouble();
            double z = this.unpacker.unpackDouble();
            return Values.point(srid, x, y, z);
        }

        private static ZonedDateTime newZonedDateTime(long epochSecondLocal, long nano, ZoneId zoneId) {
            Instant instant = Instant.ofEpochSecond(epochSecondLocal, nano);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
            return ZonedDateTime.of(localDateTime, zoneId);
        }
    }

    private static class WriterV2
    extends PackStreamMessageFormatV1.WriterV1 {
        WriterV2(PackOutput output) {
            super(output, true);
        }

        @Override
        void packInternalValue(InternalValue value) throws IOException {
            TypeConstructor typeConstructor = value.typeConstructor();
            switch (typeConstructor) {
                case DATE: {
                    this.packDate(value.asLocalDate());
                    break;
                }
                case TIME: {
                    this.packTime(value.asOffsetTime());
                    break;
                }
                case LOCAL_TIME: {
                    this.packLocalTime(value.asLocalTime());
                    break;
                }
                case LOCAL_DATE_TIME: {
                    this.packLocalDateTime(value.asLocalDateTime());
                    break;
                }
                case DATE_TIME: {
                    this.packZonedDateTime(value.asZonedDateTime());
                    break;
                }
                case DURATION: {
                    this.packDuration(value.asIsoDuration());
                    break;
                }
                case POINT: {
                    this.packPoint(value.asPoint());
                    break;
                }
                default: {
                    super.packInternalValue(value);
                }
            }
        }

        private void packDate(LocalDate localDate) throws IOException {
            this.packer.packStructHeader(1, (byte)68);
            this.packer.pack(localDate.toEpochDay());
        }

        private void packTime(OffsetTime offsetTime) throws IOException {
            long nanoOfDayLocal = offsetTime.toLocalTime().toNanoOfDay();
            int offsetSeconds = offsetTime.getOffset().getTotalSeconds();
            this.packer.packStructHeader(2, (byte)84);
            this.packer.pack(nanoOfDayLocal);
            this.packer.pack(offsetSeconds);
        }

        private void packLocalTime(LocalTime localTime) throws IOException {
            this.packer.packStructHeader(1, (byte)116);
            this.packer.pack(localTime.toNanoOfDay());
        }

        private void packLocalDateTime(LocalDateTime localDateTime) throws IOException {
            long epochSecondUtc = localDateTime.toEpochSecond(ZoneOffset.UTC);
            int nano = localDateTime.getNano();
            this.packer.packStructHeader(2, (byte)100);
            this.packer.pack(epochSecondUtc);
            this.packer.pack(nano);
        }

        private void packZonedDateTime(ZonedDateTime zonedDateTime) throws IOException {
            long epochSecondLocal = zonedDateTime.toLocalDateTime().toEpochSecond(ZoneOffset.UTC);
            int nano = zonedDateTime.getNano();
            ZoneId zone = zonedDateTime.getZone();
            if (zone instanceof ZoneOffset) {
                int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
                this.packer.packStructHeader(3, (byte)70);
                this.packer.pack(epochSecondLocal);
                this.packer.pack(nano);
                this.packer.pack(offsetSeconds);
            } else {
                String zoneId = zone.getId();
                this.packer.packStructHeader(3, (byte)102);
                this.packer.pack(epochSecondLocal);
                this.packer.pack(nano);
                this.packer.pack(zoneId);
            }
        }

        private void packDuration(IsoDuration duration) throws IOException {
            this.packer.packStructHeader(4, (byte)69);
            this.packer.pack(duration.months());
            this.packer.pack(duration.days());
            this.packer.pack(duration.seconds());
            this.packer.pack(duration.nanoseconds());
        }

        private void packPoint(Point point) throws IOException {
            if (point instanceof InternalPoint2D) {
                this.packPoint2D(point);
            } else if (point instanceof InternalPoint3D) {
                this.packPoint3D(point);
            } else {
                throw new IOException(String.format("Unknown type: type: %s, value: %s", point.getClass(), point.toString()));
            }
        }

        private void packPoint2D(Point point) throws IOException {
            this.packer.packStructHeader(3, (byte)88);
            this.packer.pack(point.srid());
            this.packer.pack(point.x());
            this.packer.pack(point.y());
        }

        private void packPoint3D(Point point) throws IOException {
            this.packer.packStructHeader(4, (byte)89);
            this.packer.pack(point.srid());
            this.packer.pack(point.x());
            this.packer.pack(point.y());
            this.packer.pack(point.z());
        }
    }
}

