/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;

public class BeginTxResponseHandler<T extends Transaction>
implements ResponseHandler {
    private final CompletableFuture<T> beginTxPromise;
    private final T tx;

    public BeginTxResponseHandler(CompletableFuture<T> beginFuture, T tx) {
        this.beginTxPromise = Objects.requireNonNull(beginFuture);
        this.tx = (Transaction)Objects.requireNonNull(tx);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.beginTxPromise.complete(this.tx);
    }

    @Override
    public void onFailure(Throwable error) {
        this.beginTxPromise.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction begin is not expected to receive records: " + Arrays.toString(fields));
    }
}

