/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Objects;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.handlers.PingResponseHandler;
import org.neo4j.driver.internal.messaging.ResetMessage;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelHealthChecker;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.util.Clock;

public class NettyChannelHealthChecker
implements ChannelHealthChecker {
    private final PoolSettings poolSettings;
    private final Clock clock;

    public NettyChannelHealthChecker(PoolSettings poolSettings, Clock clock) {
        this.poolSettings = Objects.requireNonNull(poolSettings);
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public Future<Boolean> isHealthy(Channel channel) {
        if (this.isTooOld(channel)) {
            return channel.eventLoop().newSucceededFuture(Boolean.FALSE);
        }
        if (this.hasBeenIdleForTooLong(channel)) {
            return this.ping(channel);
        }
        return ACTIVE.isHealthy(channel);
    }

    private boolean isTooOld(Channel channel) {
        if (this.poolSettings.maxConnectionLifetimeEnabled()) {
            long creationTimestampMillis = ChannelAttributes.creationTimestamp(channel);
            long currentTimestampMillis = this.clock.millis();
            long ageMillis = currentTimestampMillis - creationTimestampMillis;
            return ageMillis > this.poolSettings.maxConnectionLifetime();
        }
        return false;
    }

    private boolean hasBeenIdleForTooLong(Channel channel) {
        Long lastUsedTimestamp;
        if (this.poolSettings.idleTimeBeforeConnectionTestEnabled() && (lastUsedTimestamp = ChannelAttributes.lastUsedTimestamp(channel)) != null) {
            long idleTime = this.clock.millis() - lastUsedTimestamp;
            return idleTime > this.poolSettings.idleTimeBeforeConnectionTest();
        }
        return false;
    }

    private Future<Boolean> ping(Channel channel) {
        Promise<Boolean> result = channel.eventLoop().newPromise();
        ChannelAttributes.messageDispatcher(channel).queue(new PingResponseHandler(result));
        channel.writeAndFlush(ResetMessage.RESET, channel.voidPromise());
        return result;
    }
}

