/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DirectConnectionProvider;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.async.BoltServerAddress;
import org.neo4j.driver.internal.async.BootstrapFactory;
import org.neo4j.driver.internal.async.ChannelConnector;
import org.neo4j.driver.internal.async.ChannelConnectorImpl;
import org.neo4j.driver.internal.async.pool.ConnectionPoolImpl;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.RoundRobinLoadBalancingStrategy;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;

public class DriverFactory {
    public static final String BOLT_URI_SCHEME = "bolt";
    public static final String BOLT_ROUTING_URI_SCHEME = "bolt+routing";

    public final Driver newInstance(URI uri, AuthToken authToken, RoutingSettings routingSettings, RetrySettings retrySettings, Config config) {
        authToken = authToken == null ? AuthTokens.none() : authToken;
        BoltServerAddress address = new BoltServerAddress(uri);
        RoutingSettings newRoutingSettings = routingSettings.withRoutingContext(new RoutingContext(uri));
        SecurityPlan securityPlan = DriverFactory.createSecurityPlan(address, config);
        Bootstrap bootstrap = this.createBootstrap();
        EventLoopGroup eventExecutorGroup = bootstrap.config().group();
        RetryLogic retryLogic = this.createRetryLogic(retrySettings, eventExecutorGroup, config.logging());
        ConnectionPool connectionPool = this.createConnectionPool(authToken, securityPlan, bootstrap, config);
        try {
            InternalDriver driver = this.createDriver(uri, address, connectionPool, config, newRoutingSettings, eventExecutorGroup, securityPlan, retryLogic);
            Futures.getBlocking(driver.verifyConnectivity());
            return driver;
        }
        catch (Throwable driverError) {
            try {
                Futures.getBlocking(connectionPool.close());
            }
            catch (Throwable closeError) {
                driverError.addSuppressed(closeError);
            }
            throw driverError;
        }
    }

    protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, Config config) {
        Clock clock = this.createClock();
        ConnectionSettings settings = new ConnectionSettings(authToken, config.connectionTimeoutMillis());
        ChannelConnector connector = this.createConnector(settings, securityPlan, config, clock);
        PoolSettings poolSettings = new PoolSettings(config.maxIdleConnectionPoolSize(), config.idleTimeBeforeConnectionTest(), config.maxConnectionLifetimeMillis(), config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis());
        return new ConnectionPoolImpl(connector, bootstrap, poolSettings, config.logging(), clock);
    }

    protected ChannelConnector createConnector(ConnectionSettings settings, SecurityPlan securityPlan, Config config, Clock clock) {
        return new ChannelConnectorImpl(settings, securityPlan, config.logging(), clock);
    }

    private InternalDriver createDriver(URI uri, BoltServerAddress address, ConnectionPool connectionPool, Config config, RoutingSettings routingSettings, EventExecutorGroup eventExecutorGroup, SecurityPlan securityPlan, RetryLogic retryLogic) {
        String scheme;
        switch (scheme = uri.getScheme().toLowerCase()) {
            case "bolt": {
                DriverFactory.assertNoRoutingContext(uri, routingSettings);
                return this.createDirectDriver(address, config, securityPlan, retryLogic, connectionPool);
            }
            case "bolt+routing": {
                return this.createRoutingDriver(address, connectionPool, config, routingSettings, securityPlan, retryLogic, eventExecutorGroup);
            }
        }
        throw new ClientException(String.format("Unsupported URI scheme: %s", scheme));
    }

    protected InternalDriver createDirectDriver(BoltServerAddress address, Config config, SecurityPlan securityPlan, RetryLogic retryLogic, ConnectionPool connectionPool) {
        DirectConnectionProvider connectionProvider = new DirectConnectionProvider(address, connectionPool);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        return this.createDriver(config, securityPlan, sessionFactory);
    }

    protected InternalDriver createRoutingDriver(BoltServerAddress address, ConnectionPool connectionPool, Config config, RoutingSettings routingSettings, SecurityPlan securityPlan, RetryLogic retryLogic, EventExecutorGroup eventExecutorGroup) {
        if (!securityPlan.isRoutingCompatible()) {
            throw new IllegalArgumentException("The chosen security plan is not compatible with a routing driver");
        }
        LoadBalancer connectionProvider = this.createLoadBalancer(address, connectionPool, eventExecutorGroup, config, routingSettings);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        return this.createDriver(config, securityPlan, sessionFactory);
    }

    protected InternalDriver createDriver(Config config, SecurityPlan securityPlan, SessionFactory sessionFactory) {
        return new InternalDriver(securityPlan, sessionFactory);
    }

    protected LoadBalancer createLoadBalancer(BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, Config config, RoutingSettings routingSettings) {
        LoadBalancingStrategy loadBalancingStrategy = DriverFactory.createLoadBalancingStrategy(config, connectionPool);
        return new LoadBalancer(address, routingSettings, connectionPool, eventExecutorGroup, this.createClock(), config.logging(), loadBalancingStrategy);
    }

    private static LoadBalancingStrategy createLoadBalancingStrategy(Config config, ConnectionPool connectionPool) {
        switch (config.loadBalancingStrategy()) {
            case ROUND_ROBIN: {
                return new RoundRobinLoadBalancingStrategy(config.logging());
            }
            case LEAST_CONNECTED: {
                return new LeastConnectedLoadBalancingStrategy(connectionPool, config.logging());
            }
        }
        throw new IllegalArgumentException("Unknown load balancing strategy: " + (Object)((Object)config.loadBalancingStrategy()));
    }

    protected Clock createClock() {
        return Clock.SYSTEM;
    }

    protected SessionFactory createSessionFactory(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        return new SessionFactoryImpl(connectionProvider, retryLogic, config);
    }

    protected RetryLogic createRetryLogic(RetrySettings settings, EventExecutorGroup eventExecutorGroup, Logging logging) {
        return new ExponentialBackoffRetryLogic(settings, eventExecutorGroup, this.createClock(), logging);
    }

    protected Bootstrap createBootstrap() {
        return BootstrapFactory.newBootstrap();
    }

    private static SecurityPlan createSecurityPlan(BoltServerAddress address, Config config) {
        try {
            return DriverFactory.createSecurityPlanImpl(address, config);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new ClientException("Unable to establish SSL parameters", ex);
        }
    }

    private static SecurityPlan createSecurityPlanImpl(BoltServerAddress address, Config config) throws GeneralSecurityException, IOException {
        if (config.encrypted()) {
            Logger logger = config.logging().getLog("SecurityPlan");
            switch (config.trustStrategy().strategy()) {
                case TRUST_ON_FIRST_USE: {
                    logger.warn("Option `TRUST_ON_FIRST_USE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_ALL_CERTIFICATES` instead.", new Object[0]);
                    return SecurityPlan.forTrustOnFirstUse(config.trustStrategy().certFile(), address, logger);
                }
                case TRUST_SIGNED_CERTIFICATES: {
                    logger.warn("Option `TRUST_SIGNED_CERTIFICATE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_CUSTOM_CA_SIGNED_CERTIFICATES` instead.", new Object[0]);
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forCustomCASignedCertificates(config.trustStrategy().certFile());
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forSystemCASignedCertificates();
                }
                case TRUST_ALL_CERTIFICATES: {
                    return SecurityPlan.forAllCertificates();
                }
            }
            throw new ClientException("Unknown TLS authentication strategy: " + config.trustStrategy().strategy().name());
        }
        return SecurityPlan.insecure();
    }

    private static void assertNoRoutingContext(URI uri, RoutingSettings routingSettings) {
        RoutingContext routingContext = routingSettings.routingContext();
        if (routingContext.isDefined()) {
            throw new IllegalArgumentException("Routing parameters are not supported with scheme 'bolt'. Given URI: '" + uri + "'");
        }
    }
}

