/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.async.BoltServerAddress;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.HostNameResolver;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.exceptions.SecurityException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class Rediscovery {
    private static final String NO_ROUTERS_AVAILABLE = "Could not perform discovery. No routing servers available.";
    private final BoltServerAddress initialRouter;
    private final RoutingSettings settings;
    private final Logger logger;
    private final ClusterCompositionProvider provider;
    private final HostNameResolver hostNameResolver;
    private final EventExecutorGroup eventExecutorGroup;
    private volatile boolean useInitialRouter;

    public Rediscovery(BoltServerAddress initialRouter, RoutingSettings settings, ClusterCompositionProvider provider, EventExecutorGroup eventExecutorGroup, HostNameResolver hostNameResolver, Logger logger) {
        this(initialRouter, settings, provider, hostNameResolver, eventExecutorGroup, logger, true);
    }

    public Rediscovery(BoltServerAddress initialRouter, RoutingSettings settings, ClusterCompositionProvider provider, HostNameResolver hostNameResolver, EventExecutorGroup eventExecutorGroup, Logger logger, boolean useInitialRouter) {
        this.initialRouter = initialRouter;
        this.settings = settings;
        this.logger = logger;
        this.provider = provider;
        this.hostNameResolver = hostNameResolver;
        this.eventExecutorGroup = eventExecutorGroup;
        this.useInitialRouter = useInitialRouter;
    }

    public CompletionStage<ClusterComposition> lookupClusterComposition(RoutingTable routingTable, ConnectionPool connectionPool) {
        CompletableFuture<ClusterComposition> result = new CompletableFuture<ClusterComposition>();
        this.lookupClusterComposition(routingTable, connectionPool, 0, 0L, result);
        return result;
    }

    private void lookupClusterComposition(RoutingTable routingTable, ConnectionPool pool, int failures, long previousDelay, CompletableFuture<ClusterComposition> result) {
        if (failures >= this.settings.maxRoutingFailures()) {
            result.completeExceptionally(new ServiceUnavailableException(NO_ROUTERS_AVAILABLE));
            return;
        }
        this.lookup(routingTable, pool).whenComplete((composition, completionError) -> {
            Throwable error = Futures.completionErrorCause(completionError);
            if (error != null) {
                result.completeExceptionally(error);
            } else if (composition != null) {
                result.complete((ClusterComposition)composition);
            } else {
                long nextDelay = Math.max(this.settings.retryTimeoutDelay(), previousDelay * 2L);
                this.logger.info("Unable to fetch new routing table, will try again in " + nextDelay + "ms", new Object[0]);
                this.eventExecutorGroup.next().schedule(() -> this.lookupClusterComposition(routingTable, pool, failures + 1, nextDelay, result), nextDelay, TimeUnit.MILLISECONDS);
            }
        });
    }

    private CompletionStage<ClusterComposition> lookup(RoutingTable routingTable, ConnectionPool connectionPool) {
        CompletionStage<ClusterComposition> compositionStage;
        if (this.useInitialRouter) {
            compositionStage = this.lookupOnInitialRouterThenOnKnownRouters(routingTable, connectionPool);
            this.useInitialRouter = false;
        } else {
            compositionStage = this.lookupOnKnownRoutersThenOnInitialRouter(routingTable, connectionPool);
        }
        return compositionStage.whenComplete((composition, error) -> {
            if (composition != null && !composition.hasWriters()) {
                this.useInitialRouter = true;
            }
        });
    }

    private CompletionStage<ClusterComposition> lookupOnKnownRoutersThenOnInitialRouter(RoutingTable routingTable, ConnectionPool connectionPool) {
        HashSet<BoltServerAddress> seenServers = new HashSet<BoltServerAddress>();
        return this.lookupOnKnownRouters(routingTable, connectionPool, seenServers).thenCompose(composition -> {
            if (composition != null) {
                return CompletableFuture.completedFuture(composition);
            }
            return this.lookupOnInitialRouter(routingTable, connectionPool, seenServers);
        });
    }

    private CompletionStage<ClusterComposition> lookupOnInitialRouterThenOnKnownRouters(RoutingTable routingTable, ConnectionPool connectionPool) {
        Set<BoltServerAddress> seenServers = Collections.emptySet();
        return this.lookupOnInitialRouter(routingTable, connectionPool, seenServers).thenCompose(composition -> {
            if (composition != null) {
                return CompletableFuture.completedFuture(composition);
            }
            return this.lookupOnKnownRouters(routingTable, connectionPool, new HashSet<BoltServerAddress>());
        });
    }

    private CompletionStage<ClusterComposition> lookupOnKnownRouters(RoutingTable routingTable, ConnectionPool connectionPool, Set<BoltServerAddress> seenServers) {
        BoltServerAddress[] addresses = routingTable.routers().toArray();
        CompletionStage<Object> result = CompletableFuture.completedFuture(null);
        for (BoltServerAddress address : addresses) {
            result = result.thenCompose(composition -> {
                if (composition != null) {
                    return CompletableFuture.completedFuture(composition);
                }
                return this.lookupOnRouter(address, routingTable, connectionPool).whenComplete((ignore, error) -> seenServers.add(address));
            });
        }
        return result;
    }

    private CompletionStage<ClusterComposition> lookupOnInitialRouter(RoutingTable routingTable, ConnectionPool connectionPool, Set<BoltServerAddress> seenServers) {
        Set<BoltServerAddress> addresses = this.hostNameResolver.resolve(this.initialRouter);
        addresses.removeAll(seenServers);
        CompletionStage<Object> result = CompletableFuture.completedFuture(null);
        for (BoltServerAddress address : addresses) {
            result = result.thenCompose(composition -> {
                if (composition != null) {
                    return CompletableFuture.completedFuture(composition);
                }
                return this.lookupOnRouter(address, routingTable, connectionPool);
            });
        }
        return result;
    }

    private CompletionStage<ClusterComposition> lookupOnRouter(BoltServerAddress routerAddress, RoutingTable routingTable, ConnectionPool connectionPool) {
        CompletionStage<Connection> connectionStage = connectionPool.acquire(routerAddress);
        return this.provider.getClusterComposition(connectionStage).handle((response, error) -> {
            Throwable cause = Futures.completionErrorCause(error);
            if (cause != null) {
                return this.handleRoutingProcedureError(cause, routingTable, routerAddress);
            }
            ClusterComposition cluster = response.clusterComposition();
            this.logger.info("Got cluster composition %s", cluster);
            return cluster;
        });
    }

    private ClusterComposition handleRoutingProcedureError(Throwable error, RoutingTable routingTable, BoltServerAddress routerAddress) {
        if (error instanceof SecurityException) {
            throw new CompletionException(error);
        }
        this.logger.error(String.format("Failed to connect to routing server '%s'.", routerAddress), error);
        routingTable.forget(routerAddress);
        return null;
    }
}

