/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.async.InternalStatementResultCursor;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.SessionPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.TransactionPullAllResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public final class QueryRunner {
    private QueryRunner() {
    }

    public static CompletionStage<InternalStatementResultCursor> runAsBlocking(Connection connection, Statement statement) {
        return QueryRunner.runAsBlocking(connection, statement, null);
    }

    public static CompletionStage<InternalStatementResultCursor> runAsBlocking(Connection connection, Statement statement, ExplicitTransaction tx) {
        return QueryRunner.runAsAsync(connection, statement, tx, false);
    }

    public static CompletionStage<InternalStatementResultCursor> runAsAsync(Connection connection, Statement statement) {
        return QueryRunner.runAsAsync(connection, statement, null);
    }

    public static CompletionStage<InternalStatementResultCursor> runAsAsync(Connection connection, Statement statement, ExplicitTransaction tx) {
        return QueryRunner.runAsAsync(connection, statement, tx, true);
    }

    private static CompletionStage<InternalStatementResultCursor> runAsAsync(Connection connection, Statement statement, ExplicitTransaction tx, boolean async) {
        String query = statement.text();
        Map<String, Value> params = statement.parameters().asMap(Values.ofValue());
        CompletableFuture<Void> runCompletedFuture = new CompletableFuture<Void>();
        RunResponseHandler runHandler = new RunResponseHandler(runCompletedFuture);
        PullAllResponseHandler pullAllHandler = QueryRunner.newPullAllHandler(statement, runHandler, connection, tx);
        connection.runAndFlush(query, params, runHandler, pullAllHandler);
        if (async) {
            return runCompletedFuture.thenApply(ignore -> InternalStatementResultCursor.forAsyncRun(runHandler, pullAllHandler));
        }
        return CompletableFuture.completedFuture(InternalStatementResultCursor.forBlockingRun(runHandler, pullAllHandler));
    }

    private static PullAllResponseHandler newPullAllHandler(Statement statement, RunResponseHandler runHandler, Connection connection, ExplicitTransaction tx) {
        if (tx != null) {
            return new TransactionPullAllResponseHandler(statement, runHandler, connection, tx);
        }
        return new SessionPullAllResponseHandler(statement, runHandler, connection);
    }
}

