/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.handlers.InitResponseHandler;
import org.neo4j.driver.internal.messaging.InitMessage;
import org.neo4j.driver.v1.Value;

public class HandshakeCompletedListener
implements ChannelFutureListener {
    private final String userAgent;
    private final Map<String, Value> authToken;
    private final ChannelPromise connectionInitializedPromise;

    public HandshakeCompletedListener(String userAgent, Map<String, Value> authToken, ChannelPromise connectionInitializedPromise) {
        this.userAgent = Objects.requireNonNull(userAgent);
        this.authToken = Objects.requireNonNull(authToken);
        this.connectionInitializedPromise = Objects.requireNonNull(connectionInitializedPromise);
    }

    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            Channel channel = future.channel();
            InitMessage message = new InitMessage(this.userAgent, this.authToken);
            InitResponseHandler handler = new InitResponseHandler(this.connectionInitializedPromise);
            ChannelAttributes.messageDispatcher(channel).queue(handler);
            channel.writeAndFlush((Object)message, channel.voidPromise());
        } else {
            this.connectionInitializedPromise.setFailure(future.cause());
        }
    }
}

