/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.async.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.v1.AccessMode;

public class DirectConnectionProvider
implements ConnectionProvider {
    private final BoltServerAddress address;
    private final ConnectionPool connectionPool;

    DirectConnectionProvider(BoltServerAddress address, ConnectionPool connectionPool) {
        this.address = address;
        this.connectionPool = connectionPool;
    }

    @Override
    public CompletionStage<Connection> acquireConnection(AccessMode mode) {
        return this.connectionPool.acquire(this.address);
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.acquireConnection(AccessMode.READ).thenCompose(Connection::releaseNow);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionPool.close();
    }

    public BoltServerAddress getAddress() {
        return this.address;
    }
}

