/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public final class Bookmark {
    private static final String BOOKMARK_KEY = "bookmark";
    private static final String BOOKMARKS_KEY = "bookmarks";
    private static final String BOOKMARK_PREFIX = "neo4j:bookmark:v1:tx";
    private static final long UNKNOWN_BOOKMARK_VALUE = -1L;
    private static final Bookmark EMPTY = new Bookmark(Collections.emptySet());
    private final Iterable<String> values;
    private final String maxValue;

    private Bookmark(Iterable<String> values) {
        this.values = values;
        this.maxValue = Bookmark.maxBookmark(values);
    }

    public static Bookmark empty() {
        return EMPTY;
    }

    public static Bookmark from(String value) {
        if (value == null) {
            return Bookmark.empty();
        }
        return Bookmark.from(Collections.singleton(value));
    }

    public static Bookmark from(Iterable<String> values) {
        if (values == null) {
            return Bookmark.empty();
        }
        return new Bookmark(values);
    }

    public boolean isEmpty() {
        return this.maxValue == null;
    }

    public String maxBookmarkAsString() {
        return this.maxValue;
    }

    public Map<String, Value> asBeginTransactionParameters() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> parameters = new HashMap<String, Value>(4);
        parameters.put(BOOKMARK_KEY, Values.value(this.maxValue));
        parameters.put(BOOKMARKS_KEY, Values.value(this.values));
        return parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bookmark bookmark = (Bookmark)o;
        return Objects.equals(this.values, bookmark.values) && Objects.equals(this.maxValue, bookmark.maxValue);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.maxValue);
    }

    public String toString() {
        return "Bookmark{values=" + this.values + "}";
    }

    private static String maxBookmark(Iterable<String> bookmarks) {
        if (bookmarks == null) {
            return null;
        }
        Iterator<String> iterator = bookmarks.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        String maxBookmark = iterator.next();
        long maxValue = Bookmark.bookmarkValue(maxBookmark);
        while (iterator.hasNext()) {
            String bookmark = iterator.next();
            long value = Bookmark.bookmarkValue(bookmark);
            if (value <= maxValue) continue;
            maxBookmark = bookmark;
            maxValue = value;
        }
        return maxBookmark;
    }

    private static long bookmarkValue(String value) {
        if (value != null && value.startsWith(BOOKMARK_PREFIX)) {
            try {
                return Long.parseLong(value.substring(BOOKMARK_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }
}

