/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.Map;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.ServerInfo;

public class PooledSocketConnection
implements PooledConnection {
    private final Connection delegate;
    private final Consumer<PooledConnection> release;
    private boolean unrecoverableErrorsOccurred = false;
    private SessionResourcesHandler resourcesHandler;
    private final Clock clock;
    private final long creationTimestamp;
    private long lastUsedTimestamp;

    public PooledSocketConnection(Connection delegate, Consumer<PooledConnection> release, Clock clock) {
        this.delegate = delegate;
        this.release = release;
        this.clock = clock;
        this.creationTimestamp = clock.millis();
        this.updateLastUsedTimestamp();
    }

    @Override
    public void init(String clientName, Map<String, Value> authToken) {
        try {
            this.delegate.init(clientName, authToken);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, ResponseHandler handler) {
        try {
            this.delegate.run(statement, parameters, handler);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void discardAll(ResponseHandler handler) {
        try {
            this.delegate.discardAll(handler);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void pullAll(ResponseHandler handler) {
        try {
            this.delegate.pullAll(handler);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void reset() {
        try {
            this.delegate.reset();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void ackFailure() {
        try {
            this.delegate.ackFailure();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void sync() {
        try {
            this.delegate.sync();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.delegate.flush();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void receiveOne() {
        try {
            this.delegate.receiveOne();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void close() {
        this.updateLastUsedTimestamp();
        this.resourcesHandler = null;
        this.release.accept(this);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean hasUnrecoverableErrors() {
        return this.unrecoverableErrorsOccurred;
    }

    @Override
    public void resetAsync() {
        try {
            this.delegate.resetAsync();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public boolean isAckFailureMuted() {
        return this.delegate.isAckFailureMuted();
    }

    @Override
    public ServerInfo server() {
        return this.delegate.server();
    }

    @Override
    public BoltServerAddress boltServerAddress() {
        return this.delegate.boltServerAddress();
    }

    @Override
    public void dispose() {
        this.delegate.close();
    }

    private void onDelegateException(RuntimeException e) {
        if (!ErrorUtil.isRecoverable(e)) {
            this.unrecoverableErrorsOccurred = true;
        } else if (!this.isAckFailureMuted()) {
            this.ackFailure();
        }
        if (this.resourcesHandler != null) {
            this.resourcesHandler.onConnectionError(!this.unrecoverableErrorsOccurred);
        }
        throw e;
    }

    @Override
    public void setResourcesHandler(SessionResourcesHandler resourcesHandler) {
        this.resourcesHandler = resourcesHandler;
    }

    @Override
    public long creationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public long lastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    private void updateLastUsedTimestamp() {
        this.lastUsedTimestamp = this.clock.millis();
    }
}

