/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.outbound.OutboundMessageHandler;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Value;

public class AsyncInitResponseHandler
implements ResponseHandler {
    private final ChannelPromise connectionInitializedPromise;
    private final Channel channel;

    public AsyncInitResponseHandler(ChannelPromise connectionInitializedPromise) {
        this.connectionInitializedPromise = connectionInitializedPromise;
        this.channel = connectionInitializedPromise.channel();
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            ServerVersion serverVersion = AsyncInitResponseHandler.extractServerVersion(metadata);
            ChannelAttributes.setServerVersion(this.channel, serverVersion);
            AsyncInitResponseHandler.updatePipelineIfNeeded(serverVersion, this.channel.pipeline());
            this.connectionInitializedPromise.setSuccess();
        }
        catch (Throwable error) {
            this.connectionInitializedPromise.setFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener(future -> this.connectionInitializedPromise.setFailure(error));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private static ServerVersion extractServerVersion(Map<String, Value> metadata) {
        Value versionValue = metadata.get("server");
        boolean versionAbsent = versionValue == null || versionValue.isNull();
        return versionAbsent ? ServerVersion.v3_0_0 : ServerVersion.version(versionValue.asString());
    }

    private static void updatePipelineIfNeeded(ServerVersion serverVersion, ChannelPipeline pipeline) {
        if (serverVersion.lessThan(ServerVersion.v3_2_0)) {
            OutboundMessageHandler outboundHandler = (OutboundMessageHandler)pipeline.get(OutboundMessageHandler.class);
            if (outboundHandler == null) {
                throw new IllegalStateException("Can't find " + OutboundMessageHandler.NAME + " in the pipeline");
            }
            pipeline.replace((ChannelHandler)outboundHandler, OutboundMessageHandler.NAME, (ChannelHandler)outboundHandler.withoutByteArraySupport());
        }
    }
}

