/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.neo4j.driver.v1.summary.ServerInfo;

public class RoutingPooledConnection
implements PooledConnection {
    private final PooledConnection delegate;
    private final RoutingErrorHandler errorHandler;
    private final AccessMode accessMode;

    public RoutingPooledConnection(PooledConnection delegate, RoutingErrorHandler errorHandler, AccessMode accessMode) {
        this.delegate = delegate;
        this.errorHandler = errorHandler;
        this.accessMode = accessMode;
    }

    @Override
    public void init(String clientName, Map<String, Value> authToken) {
        try {
            this.delegate.init(clientName, authToken);
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, ResponseHandler handler) {
        try {
            this.delegate.run(statement, parameters, handler);
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void discardAll(ResponseHandler handler) {
        try {
            this.delegate.discardAll(handler);
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void pullAll(ResponseHandler handler) {
        try {
            this.delegate.pullAll(handler);
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void reset() {
        try {
            this.delegate.reset();
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void resetAsync() {
        try {
            this.delegate.resetAsync();
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void ackFailure() {
        try {
            this.delegate.ackFailure();
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void sync() {
        try {
            this.delegate.sync();
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.delegate.flush();
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void receiveOne() {
        try {
            this.delegate.receiveOne();
        }
        catch (RuntimeException e) {
            throw this.handledException(e);
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void setResourcesHandler(SessionResourcesHandler resourcesHandler) {
        this.delegate.setResourcesHandler(resourcesHandler);
    }

    @Override
    public boolean hasUnrecoverableErrors() {
        return this.delegate.hasUnrecoverableErrors();
    }

    @Override
    public boolean isAckFailureMuted() {
        return this.delegate.isAckFailureMuted();
    }

    @Override
    public ServerInfo server() {
        return this.delegate.server();
    }

    @Override
    public BoltServerAddress boltServerAddress() {
        return this.delegate.boltServerAddress();
    }

    @Override
    public long creationTimestamp() {
        return this.delegate.creationTimestamp();
    }

    @Override
    public long lastUsedTimestamp() {
        return this.delegate.lastUsedTimestamp();
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    private RuntimeException handledException(RuntimeException e) {
        if (e instanceof ServiceUnavailableException) {
            return this.handledServiceUnavailableException((ServiceUnavailableException)e);
        }
        if (e instanceof ClientException) {
            return this.handledClientException((ClientException)e);
        }
        if (e instanceof TransientException) {
            return this.handledTransientException((TransientException)e);
        }
        return e;
    }

    private RuntimeException handledServiceUnavailableException(ServiceUnavailableException e) {
        BoltServerAddress address = this.boltServerAddress();
        this.errorHandler.onConnectionFailure(address);
        return new SessionExpiredException(String.format("Server at %s is no longer available", address), e);
    }

    private RuntimeException handledTransientException(TransientException e) {
        String errorCode = e.code();
        if (Objects.equals(errorCode, "Neo.TransientError.General.DatabaseUnavailable")) {
            BoltServerAddress address = this.boltServerAddress();
            this.errorHandler.onConnectionFailure(address);
        }
        return e;
    }

    private RuntimeException handledClientException(ClientException e) {
        if (RoutingPooledConnection.isFailureToWrite(e)) {
            switch (this.accessMode) {
                case READ: {
                    return new ClientException("Write queries cannot be performed in READ access mode.");
                }
                case WRITE: {
                    BoltServerAddress address = this.boltServerAddress();
                    this.errorHandler.onWriteFailure(address);
                    return new SessionExpiredException(String.format("Server at %s no longer accepts writes", address));
                }
            }
            throw new IllegalArgumentException((Object)((Object)this.accessMode) + " not supported.");
        }
        return e;
    }

    private static boolean isFailureToWrite(ClientException e) {
        String errorCode = e.code();
        return Objects.equals(errorCode, "Neo.ClientError.Cluster.NotALeader") || Objects.equals(errorCode, "Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }
}

