/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

public class PoolSettings {
    public static final int NO_IDLE_CONNECTION_TEST = -1;
    public static final int INFINITE_CONNECTION_LIFETIME = -1;
    public static final int NOT_CONFIGURED = -1;
    public static final int DEFAULT_MAX_IDLE_CONNECTION_POOL_SIZE = 10;
    public static final int DEFAULT_MAX_CONNECTION_POOL_SIZE = Integer.MAX_VALUE;
    public static final long DEFAULT_IDLE_TIME_BEFORE_CONNECTION_TEST = -1L;
    public static final long DEFAULT_MAX_CONNECTION_LIFETIME = -1L;
    public static final long DEFAULT_CONNECTION_ACQUISITION_TIMEOUT = Long.MAX_VALUE;
    private final int maxIdleConnectionPoolSize;
    private final long idleTimeBeforeConnectionTest;
    private final long maxConnectionLifetime;
    private final int maxConnectionPoolSize;
    private final long connectionAcquisitionTimeout;

    public PoolSettings(int maxIdleConnectionPoolSize, long idleTimeBeforeConnectionTest, long maxConnectionLifetime, int maxConnectionPoolSize, long connectionAcquisitionTimeout) {
        this.maxIdleConnectionPoolSize = maxIdleConnectionPoolSize;
        this.idleTimeBeforeConnectionTest = idleTimeBeforeConnectionTest;
        this.maxConnectionLifetime = maxConnectionLifetime;
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        this.connectionAcquisitionTimeout = connectionAcquisitionTimeout;
    }

    public int maxIdleConnectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public long idleTimeBeforeConnectionTest() {
        return this.idleTimeBeforeConnectionTest;
    }

    public boolean idleTimeBeforeConnectionTestEnabled() {
        return this.idleTimeBeforeConnectionTest >= 0L;
    }

    public long maxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    public boolean maxConnectionLifetimeEnabled() {
        return this.maxConnectionLifetime > 0L;
    }

    public int maxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public long connectionAcquisitionTimeout() {
        return this.connectionAcquisitionTimeout;
    }
}

