/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.async.InternalStatementResultCursor;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.SessionPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.TransactionPullAllResponseHandler;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public final class QueryRunner {
    private QueryRunner() {
    }

    public static CompletionStage<StatementResultCursor> runAsync(AsyncConnection connection, Statement statement) {
        return QueryRunner.runAsync(connection, statement, null);
    }

    public static CompletionStage<StatementResultCursor> runAsync(AsyncConnection connection, Statement statement, ExplicitTransaction tx) {
        String query = statement.text();
        Map<String, Value> params = statement.parameters().asMap(Values.ofValue());
        CompletableFuture<Void> runCompletedFuture = new CompletableFuture<Void>();
        RunResponseHandler runHandler = new RunResponseHandler(runCompletedFuture, tx);
        PullAllResponseHandler pullAllHandler = QueryRunner.newPullAllHandler(statement, runHandler, connection, tx);
        connection.runAndFlush(query, params, runHandler, pullAllHandler);
        return runCompletedFuture.thenApply(ignore -> new InternalStatementResultCursor(runHandler, pullAllHandler));
    }

    private static PullAllResponseHandler newPullAllHandler(Statement statement, RunResponseHandler runHandler, AsyncConnection connection, ExplicitTransaction tx) {
        if (tx != null) {
            return new TransactionPullAllResponseHandler(statement, runHandler, connection, tx);
        }
        return new SessionPullAllResponseHandler(statement, runHandler, connection);
    }
}

