/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import org.neo4j.driver.internal.async.HandshakeResponseHandler;
import org.neo4j.driver.internal.async.ProtocolUtil;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class ChannelConnectedListener
implements ChannelFutureListener {
    private final BoltServerAddress address;
    private final ChannelPromise handshakeCompletedPromise;
    private final Logging logging;

    public ChannelConnectedListener(BoltServerAddress address, ChannelPromise handshakeCompletedPromise, Logging logging) {
        this.address = Objects.requireNonNull(address);
        this.handshakeCompletedPromise = Objects.requireNonNull(handshakeCompletedPromise);
        this.logging = Objects.requireNonNull(logging);
    }

    public void operationComplete(ChannelFuture future) {
        Channel channel = future.channel();
        if (future.isSuccess()) {
            channel.pipeline().addLast(new ChannelHandler[]{new HandshakeResponseHandler(this.handshakeCompletedPromise, this.logging)});
            ChannelFuture handshakeFuture = channel.writeAndFlush((Object)ProtocolUtil.handshake());
            handshakeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ChannelConnectedListener.this.handshakeCompletedPromise.setFailure(future.cause());
                    }
                }
            });
        } else {
            this.handshakeCompletedPromise.setFailure(ChannelConnectedListener.databaseUnavailableError(this.address, future.cause()));
        }
    }

    private static Throwable databaseUnavailableError(BoltServerAddress address, Throwable cause) {
        return new ServiceUnavailableException(String.format("Unable to connect to %s, ensure the database is running and that there is a working network connection to it.", address), cause);
    }
}

