/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;

public class ServerVersion {
    private static final String NEO4J_IN_DEV_VERSION_STRING = "Neo4j/dev";
    private final int major;
    private final int minor;
    private final int patch;
    private static final Pattern PATTERN = Pattern.compile("(Neo4j/)?(\\d+)\\.(\\d+)(?:\\.)?(\\d*)(\\.|-|\\+)?([0-9A-Za-z-.]*)?");
    public static final ServerVersion v3_2_0 = new ServerVersion(3, 2, 0);
    public static final ServerVersion v3_1_0 = new ServerVersion(3, 1, 0);
    public static final ServerVersion v3_0_0 = new ServerVersion(3, 0, 0);
    public static final ServerVersion vInDev = new ServerVersion(0, 0, 0);

    private ServerVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static ServerVersion version(Driver driver) {
        try (Session session = driver.session();){
            String versionString = session.run("RETURN 1").consume().server().version();
            ServerVersion serverVersion = ServerVersion.version(versionString);
            return serverVersion;
        }
    }

    public static ServerVersion version(String server) {
        if (server == null) {
            return new ServerVersion(3, 0, 0);
        }
        Matcher matcher = PATTERN.matcher(server);
        if (matcher.matches()) {
            int major = Integer.valueOf(matcher.group(2));
            int minor = Integer.valueOf(matcher.group(3));
            String patchString = matcher.group(4);
            int patch = 0;
            if (patchString != null && !patchString.isEmpty()) {
                patch = Integer.valueOf(patchString);
            }
            return new ServerVersion(major, minor, patch);
        }
        if (server.equalsIgnoreCase(NEO4J_IN_DEV_VERSION_STRING)) {
            return vInDev;
        }
        throw new IllegalArgumentException("Cannot parse " + server);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerVersion that = (ServerVersion)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        return this.patch == that.patch;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean greaterThan(ServerVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterThanOrEqual(ServerVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean lessThan(ServerVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean lessThanOrEqual(ServerVersion other) {
        return this.compareTo(other) <= 0;
    }

    private int compareTo(ServerVersion o) {
        int c = Integer.compare(this.major, o.major);
        if (c == 0 && (c = Integer.compare(this.minor, o.minor)) == 0) {
            c = Integer.compare(this.patch, o.patch);
        }
        return c;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.major, this.minor, this.patch);
    }
}

