/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageHandler;
import org.neo4j.driver.v1.Value;

public class InitMessage
implements Message {
    private final String userAgent;
    private Map<String, Value> authToken;

    public InitMessage(String userAgent, Map<String, Value> authToken) {
        this.userAgent = userAgent;
        this.authToken = authToken;
    }

    @Override
    public void dispatch(MessageHandler handler) throws IOException {
        handler.handleInitMessage(this.userAgent, this.authToken);
    }

    public String toString() {
        return String.format("INIT \"%s\" {...}", this.userAgent, this.authToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitMessage that = (InitMessage)o;
        return !(this.userAgent == null ? that.userAgent != null : !this.userAgent.equals(that.userAgent));
    }

    public int hashCode() {
        return this.userAgent != null ? this.userAgent.hashCode() : 0;
    }
}

