/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

public class SessionFactoryImpl
implements SessionFactory {
    protected final ConnectionProvider connectionProvider;
    protected final RetryLogic retryLogic;
    protected final Logging logging;
    protected final boolean leakedSessionsLoggingEnabled;

    SessionFactoryImpl(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        this.connectionProvider = connectionProvider;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
    }

    @Override
    public Session newInstance(AccessMode mode, String bookmark) {
        NetworkSession session = this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(this.connectionProvider, mode, this.retryLogic, this.logging) : new NetworkSession(this.connectionProvider, mode, this.retryLogic, this.logging);
        session.setBookmark(bookmark);
        return session;
    }

    @Override
    public void close() throws Exception {
        this.connectionProvider.close();
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }
}

