/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.util.Map;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.ConcurrencyGuardingConnection;
import org.neo4j.driver.internal.net.SocketConnection;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.Connector;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class SocketConnector
implements Connector {
    private final ConnectionSettings connectionSettings;
    private final SecurityPlan securityPlan;
    private final Logging logging;

    public SocketConnector(ConnectionSettings connectionSettings, SecurityPlan securityPlan, Logging logging) {
        this.connectionSettings = connectionSettings;
        this.securityPlan = securityPlan;
        this.logging = logging;
    }

    @Override
    public final Connection connect(BoltServerAddress address) {
        Connection connection = this.createConnection(address, this.securityPlan, this.connectionSettings.timeoutMillis(), this.logging);
        connection = new ConcurrencyGuardingConnection(connection);
        try {
            connection.init(this.connectionSettings.userAgent(), SocketConnector.tokenAsMap(this.connectionSettings.authToken()));
        }
        catch (Throwable initError) {
            connection.close();
            throw initError;
        }
        return connection;
    }

    Connection createConnection(BoltServerAddress address, SecurityPlan securityPlan, int timeoutMillis, Logging logging) {
        return new SocketConnection(address, securityPlan, timeoutMillis, logging);
    }

    private static Map<String, Value> tokenAsMap(AuthToken token) {
        if (token instanceof InternalAuthToken) {
            return ((InternalAuthToken)token).toMap();
        }
        throw new ClientException("Unknown authentication token, `" + token + "`. Please use one of the supported " + "tokens from `" + AuthTokens.class.getSimpleName() + "`.");
    }
}

