/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.retry.RetryDecision;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TransactionWork;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.TypeSystem;

public class NetworkSession
implements Session,
SessionResourcesHandler {
    private final ConnectionProvider connectionProvider;
    private final AccessMode mode;
    private final RetryLogic<RetryDecision> retryLogic;
    protected final Logger logger;
    private String lastBookmark;
    private PooledConnection currentConnection;
    private ExplicitTransaction currentTransaction;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);

    public NetworkSession(ConnectionProvider connectionProvider, AccessMode mode, RetryLogic<RetryDecision> retryLogic, Logging logging) {
        this.connectionProvider = connectionProvider;
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logger = logging.getLog("Session-" + this.hashCode());
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        this.ensureSessionIsOpen();
        this.ensureNoOpenTransactionBeforeRunningSession();
        this.syncAndCloseCurrentConnection();
        this.currentConnection = this.acquireConnection(this.mode);
        return NetworkSession.run(this.currentConnection, statement, this);
    }

    public static StatementResult run(Connection connection, Statement statement, SessionResourcesHandler resourcesHandler) {
        InternalStatementResult result = new InternalStatementResult(connection, resourcesHandler, null, statement);
        connection.run(statement.text(), statement.parameters().asMap(Values.ofValue()), result.runResponseCollector());
        connection.pullAll(result.pullAllResponseCollector());
        connection.flush();
        return result;
    }

    @Override
    public synchronized void reset() {
        this.ensureSessionIsOpen();
        this.ensureNoUnrecoverableError();
        if (this.currentTransaction != null) {
            this.currentTransaction.markToClose();
            this.updateLastBookmarkFrom(this.currentTransaction);
            this.currentTransaction = null;
        }
        if (this.currentConnection != null) {
            this.currentConnection.resetAsync();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen.compareAndSet(true, false)) {
            throw new ClientException("This session has already been closed.");
        }
        NetworkSession networkSession = this;
        synchronized (networkSession) {
            if (this.currentTransaction != null) {
                try {
                    this.currentTransaction.close();
                }
                catch (Throwable e) {
                    this.logger.warn("WARNING: Failed to close tx due to error: " + e.toString(), new Object[0]);
                }
            }
        }
        this.syncAndCloseCurrentConnection();
    }

    @Override
    public synchronized Transaction beginTransaction() {
        return this.beginTransaction(this.mode);
    }

    @Override
    public synchronized Transaction beginTransaction(String bookmark) {
        this.lastBookmark = bookmark;
        return this.beginTransaction();
    }

    @Override
    public <T> T readTransaction(TransactionWork<T> work) {
        return this.transaction(AccessMode.READ, work);
    }

    @Override
    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.transaction(AccessMode.WRITE, work);
    }

    void setLastBookmark(String bookmark) {
        this.lastBookmark = bookmark;
    }

    @Override
    public String lastBookmark() {
        return this.lastBookmark;
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    @Override
    public synchronized void onResultConsumed() {
        this.closeCurrentConnection();
    }

    @Override
    public synchronized void onTransactionClosed(ExplicitTransaction tx) {
        if (this.currentTransaction != null && this.currentTransaction == tx) {
            this.closeCurrentConnection();
            this.updateLastBookmarkFrom(this.currentTransaction);
            this.currentTransaction = null;
        }
    }

    @Override
    public synchronized void onConnectionError(boolean recoverable) {
        if (this.currentTransaction != null) {
            if (recoverable) {
                this.currentTransaction.failure();
            } else {
                this.currentTransaction.markToClose();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized <T> T transaction(AccessMode mode, TransactionWork<T> work) {
        RetryDecision decision = null;
        List<Throwable> errors = null;
        while (true) {
            try (Transaction tx = this.beginTransaction(mode);){
                T result;
                try {
                    result = work.execute(tx);
                }
                catch (Throwable t2) {
                    tx.failure();
                    throw t2;
                }
                tx.success();
                T t = result;
                return t;
            }
            catch (Throwable newError) {
                decision = this.retryLogic.apply(newError, decision);
                if (!decision.shouldRetry()) {
                    NetworkSession.addSuppressed(newError, errors);
                    throw newError;
                }
                errors = NetworkSession.recordError(newError, errors);
                continue;
            }
            break;
        }
    }

    private synchronized Transaction beginTransaction(AccessMode mode) {
        this.ensureSessionIsOpen();
        this.ensureNoOpenTransactionBeforeOpeningTransaction();
        this.syncAndCloseCurrentConnection();
        this.currentConnection = this.acquireConnection(mode);
        this.currentTransaction = new ExplicitTransaction(this.currentConnection, this, this.lastBookmark);
        this.currentConnection.setResourcesHandler(this);
        return this.currentTransaction;
    }

    private void ensureNoUnrecoverableError() {
        if (this.currentConnection != null && this.currentConnection.hasUnrecoverableErrors()) {
            throw new ClientException("Cannot run more statements in the current session as an unrecoverable error has happened. Please close the current session and re-run your statement in a new session.");
        }
    }

    private void ensureNoOpenTransactionBeforeRunningSession() {
        if (this.currentTransaction != null) {
            throw new ClientException("Statements cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureNoOpenTransactionBeforeOpeningTransaction() {
        if (this.currentTransaction != null) {
            throw new ClientException("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureSessionIsOpen() {
        if (!this.isOpen.get()) {
            throw new ClientException("No more interaction with this session is allowed as the current session is already closed or marked as closed. You get this error either because you have a bad reference to a session that has already be closed or you are trying to reuse a session that you have called `reset` on it.");
        }
    }

    private PooledConnection acquireConnection(AccessMode mode) {
        PooledConnection connection = this.connectionProvider.acquireConnection(mode);
        this.logger.debug("Acquired connection " + connection.hashCode(), new Object[0]);
        return connection;
    }

    boolean currentConnectionIsOpen() {
        return this.currentConnection != null && this.currentConnection.isOpen();
    }

    private void syncAndCloseCurrentConnection() {
        this.closeCurrentConnection(true);
    }

    private void closeCurrentConnection() {
        this.closeCurrentConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentConnection(boolean sync) {
        if (this.currentConnection == null) {
            return;
        }
        PooledConnection connection = this.currentConnection;
        this.currentConnection = null;
        try {
            if (sync && connection.isOpen()) {
                connection.sync();
            }
        }
        finally {
            connection.close();
            this.logger.debug("Released connection " + connection.hashCode(), new Object[0]);
        }
    }

    private void updateLastBookmarkFrom(ExplicitTransaction tx) {
        if (tx.bookmark() != null) {
            this.lastBookmark = tx.bookmark();
        }
    }

    private static List<Throwable> recordError(Throwable error, List<Throwable> errors) {
        if (errors == null) {
            errors = new ArrayList<Throwable>();
        }
        errors.add(error);
        return errors;
    }

    private static void addSuppressed(Throwable error, List<Throwable> suppressedErrors) {
        if (suppressedErrors != null) {
            for (Throwable suppressedError : suppressedErrors) {
                if (error == suppressedError) continue;
                error.addSuppressed(suppressedError);
            }
        }
    }
}

