/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.util.Supplier;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class BlockingPooledConnectionQueue {
    private final BlockingQueue<PooledConnection> queue;
    private final Logger logger;
    private final AtomicBoolean isTerminating = new AtomicBoolean(false);
    private final Set<PooledConnection> acquiredConnections = Collections.newSetFromMap(new ConcurrentHashMap());

    public BlockingPooledConnectionQueue(BoltServerAddress address, int capacity, Logging logging) {
        this.queue = new LinkedBlockingQueue<PooledConnection>(capacity);
        this.logger = BlockingPooledConnectionQueue.createLogger(address, logging);
    }

    public boolean offer(PooledConnection pooledConnection) {
        PooledConnection connection;
        this.acquiredConnections.remove(pooledConnection);
        boolean offer = this.queue.offer(pooledConnection);
        if (!offer) {
            pooledConnection.dispose();
        }
        if (this.isTerminating.get() && (connection = (PooledConnection)this.queue.poll()) != null) {
            connection.dispose();
        }
        return offer;
    }

    public PooledConnection acquire(Supplier<PooledConnection> supplier) {
        PooledConnection connection = (PooledConnection)this.queue.poll();
        if (connection == null) {
            connection = supplier.get();
        }
        this.acquiredConnections.add(connection);
        if (this.isTerminating.get()) {
            this.acquiredConnections.remove(connection);
            connection.dispose();
            throw new IllegalStateException("Pool has been closed, cannot acquire new values.");
        }
        return connection;
    }

    public List<PooledConnection> toList() {
        return new ArrayList<PooledConnection>(this.queue);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public boolean contains(PooledConnection pooledConnection) {
        return this.queue.contains(pooledConnection);
    }

    public void terminate() {
        if (this.isTerminating.compareAndSet(false, true)) {
            while (!this.queue.isEmpty()) {
                PooledConnection idleConnection = (PooledConnection)this.queue.poll();
                this.disposeSafely(idleConnection);
            }
            for (PooledConnection acquiredConnection : this.acquiredConnections) {
                this.disposeSafely(acquiredConnection);
            }
        }
    }

    private void disposeSafely(PooledConnection connection) {
        try {
            if (connection != null) {
                connection.dispose();
            }
        }
        catch (Throwable disposeError) {
            this.logger.error("Error disposing connection", disposeError);
        }
    }

    private static Logger createLogger(BoltServerAddress address, Logging logging) {
        return logging.getLog("connectionQueue[" + address + "]");
    }
}

