/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.LoggingByteChannel;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.TLSSocketChannel;
import org.neo4j.driver.v1.Logger;

class ChannelFactory {
    ChannelFactory() {
    }

    static ByteChannel create(BoltServerAddress address, SecurityPlan securityPlan, int timeoutMillis, Logger log) throws IOException, GeneralSecurityException {
        SocketChannel soChannel = SocketChannel.open();
        soChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        soChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        ChannelFactory.connect(soChannel, address, timeoutMillis);
        ByteChannel channel = securityPlan.requiresEncryption() ? TLSSocketChannel.create(address, securityPlan, soChannel, log) : soChannel;
        if (log.isTraceEnabled()) {
            channel = new LoggingByteChannel(channel, log);
        }
        return channel;
    }

    private static void connect(SocketChannel soChannel, BoltServerAddress address, int timeoutMillis) throws IOException {
        Socket socket = soChannel.socket();
        try {
            socket.connect(address.toSocketAddress(), timeoutMillis);
        }
        catch (SocketTimeoutException e) {
            throw new IOException("Timeout " + timeoutMillis + "ms expired", e);
        }
    }
}

