/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.v1.Logger;

class LeakLoggingNetworkSession
extends NetworkSession {
    private final Logger log;
    private final String stackTrace;

    LeakLoggingNetworkSession(Connection connection, Logger log) {
        super(connection);
        this.log = log;
        this.stackTrace = LeakLoggingNetworkSession.captureStackTrace();
    }

    protected void finalize() throws Throwable {
        this.logLeakIfNeeded();
        super.finalize();
    }

    private void logLeakIfNeeded() {
        if (this.isOpen()) {
            this.log.error("Neo4j Session object leaked, please ensure that your applicationcalls the `close` method on Sessions before disposing of the objects.\nSession was create at:\n" + this.stackTrace, null);
        }
    }

    private static String captureStackTrace() {
        StackTraceElement[] elements;
        StringBuilder result = new StringBuilder();
        for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
            result.append("\t").append(element).append(System.lineSeparator());
        }
        return result.toString();
    }
}

