/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.v1.util.Function;

class PooledConnectionValidator
implements Function<PooledConnection, Boolean> {
    private final ConnectionPool pool;

    PooledConnectionValidator(ConnectionPool pool) {
        this.pool = pool;
    }

    @Override
    public Boolean apply(PooledConnection pooledConnection) {
        return this.pool.hasAddress(pooledConnection.boltServerAddress()) && !pooledConnection.hasUnrecoverableErrors() && PooledConnectionValidator.reset(pooledConnection);
    }

    private static boolean reset(PooledConnection conn) {
        try {
            conn.reset();
            conn.sync();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

