/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.HashSet;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.RoundRobinAddressSet;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public final class LoadBalancer
implements RoutingErrorHandler,
AutoCloseable {
    private static final int MIN_ROUTERS = 1;
    private static final String NO_ROUTERS_AVAILABLE = "Could not perform discovery. No routing servers available.";
    private final RoutingSettings settings;
    private final Clock clock;
    private final Logger log;
    private final ConnectionPool connections;
    private final ClusterComposition.Provider provider;
    private long expirationTimeout;
    private final RoundRobinAddressSet readers;
    private final RoundRobinAddressSet writers;
    private final RoundRobinAddressSet routers;

    public LoadBalancer(RoutingSettings settings, Clock clock, Logger log, ConnectionPool connections, BoltServerAddress ... routingAddresses) throws ServiceUnavailableException {
        this(settings, clock, log, connections, new ClusterComposition.Provider.Default(clock), routingAddresses);
    }

    LoadBalancer(RoutingSettings settings, Clock clock, Logger log, ConnectionPool connections, ClusterComposition.Provider provider, BoltServerAddress ... routingAddresses) throws ServiceUnavailableException {
        this.clock = clock;
        this.log = log;
        this.connections = connections;
        this.expirationTimeout = clock.millis() - 1L;
        this.provider = provider;
        this.settings = settings;
        this.readers = new RoundRobinAddressSet();
        this.writers = new RoundRobinAddressSet();
        this.routers = new RoundRobinAddressSet();
        this.routers.update(new HashSet<BoltServerAddress>(Arrays.asList(routingAddresses)), new HashSet<BoltServerAddress>());
        this.ensureRouting();
    }

    public Connection acquireReadConnection() throws ServiceUnavailableException {
        return this.acquireConnection(this.readers);
    }

    public Connection acquireWriteConnection() throws ServiceUnavailableException {
        return this.acquireConnection(this.writers);
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.writers.remove(address);
    }

    @Override
    public void close() throws Exception {
        this.connections.close();
    }

    private Connection acquireConnection(RoundRobinAddressSet servers) throws ServiceUnavailableException {
        block2: while (true) {
            this.ensureRouting();
            while (true) {
                BoltServerAddress address;
                if ((address = servers.next()) == null) continue block2;
                try {
                    return this.connections.acquire(address);
                }
                catch (ServiceUnavailableException e) {
                    this.forget(address);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private synchronized void ensureRouting() throws ServiceUnavailableException {
        if (this.stale()) {
            try {
                ClusterComposition cluster = this.lookupRoutingTable();
                this.expirationTimeout = cluster.expirationTimestamp;
                HashSet<BoltServerAddress> removed = new HashSet<BoltServerAddress>();
                this.readers.update(cluster.readers(), removed);
                this.writers.update(cluster.writers(), removed);
                this.routers.update(cluster.routers(), removed);
                for (BoltServerAddress address : removed) {
                    this.connections.purge(address);
                }
            }
            catch (InterruptedException e) {
                throw new ServiceUnavailableException("Thread was interrupted while establishing connection.", e);
            }
        }
    }

    private ClusterComposition lookupRoutingTable() throws InterruptedException, ServiceUnavailableException {
        int size = this.routers.size();
        int failures = 0;
        if (size == 0) {
            throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
        }
        long start = this.clock.millis();
        long delay = 0L;
        while (true) {
            long waitTime;
            if ((waitTime = start + delay - this.clock.millis()) > 0L) {
                this.clock.sleep(waitTime);
            }
            start = this.clock.millis();
            for (int i = 0; i < size; ++i) {
                ClusterComposition cluster;
                BoltServerAddress address = this.routers.next();
                if (address == null) {
                    throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
                }
                try (Connection connection = this.connections.acquire(address);){
                    cluster = this.provider.getClusterComposition(connection);
                }
                catch (Exception e) {
                    this.log.error(String.format("Failed to connect to routing server '%s'.", address), e);
                    continue;
                }
                if (cluster == null || !cluster.isValid()) {
                    this.log.info("Server <%s> unable to perform routing capability, dropping from list of routers.", address);
                    this.routers.remove(address);
                    if (--size != 0) continue;
                    throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
                }
                return cluster;
            }
            if (++failures > this.settings.maxRoutingFailures) {
                throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
            }
            delay = Math.max(this.settings.retryTimeoutDelay, delay * 2L);
        }
    }

    private synchronized void forget(BoltServerAddress address) {
        this.readers.remove(address);
        this.writers.remove(address);
        this.connections.purge(address);
    }

    private boolean stale() {
        return this.expirationTimeout < this.clock.millis() || this.routers.size() <= 1 || this.readers.size() == 0 || this.writers.size() == 0;
    }
}

