/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.RoutingStatementResult;
import org.neo4j.driver.internal.RoutingTransaction;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.driver.v1.types.TypeSystem;

public class RoutingNetworkSession
implements Session {
    protected final Session delegate;
    private final BoltServerAddress address;
    private final AccessMode mode;
    private final RoutingErrorHandler onError;

    RoutingNetworkSession(Session delegate, AccessMode mode, BoltServerAddress address, RoutingErrorHandler onError) {
        this.delegate = delegate;
        this.mode = mode;
        this.address = address;
        this.onError = onError;
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        try {
            return new RoutingStatementResult(this.delegate.run(statement), this.mode, this.address, this.onError);
        }
        catch (ServiceUnavailableException e) {
            throw RoutingNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw RoutingNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public TypeSystem typeSystem() {
        return this.delegate.typeSystem();
    }

    @Override
    public Transaction beginTransaction() {
        return new RoutingTransaction(this.delegate.beginTransaction(), this.mode, this.address, this.onError);
    }

    @Override
    public Transaction beginTransaction(String bookmark) {
        return new RoutingTransaction(this.delegate.beginTransaction(bookmark), this.mode, this.address, this.onError);
    }

    @Override
    public String lastBookmark() {
        return this.delegate.lastBookmark();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (ServiceUnavailableException e) {
            throw RoutingNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw RoutingNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    public BoltServerAddress address() {
        return this.address;
    }

    static Neo4jException filterFailureToWrite(ClientException e, AccessMode mode, RoutingErrorHandler onError, BoltServerAddress address) {
        if (RoutingNetworkSession.isFailedToWrite(e)) {
            switch (mode) {
                case READ: {
                    return new ClientException("Write queries cannot be performed in READ access mode.");
                }
                case WRITE: {
                    onError.onWriteFailure(address);
                    return new SessionExpiredException(String.format("Server at %s no longer accepts writes", address));
                }
            }
            throw new IllegalArgumentException((Object)((Object)mode) + " not supported.");
        }
        return e;
    }

    static SessionExpiredException sessionExpired(ServiceUnavailableException e, RoutingErrorHandler onError, BoltServerAddress address) {
        onError.onConnectionFailure(address);
        return new SessionExpiredException(String.format("Server at %s is no longer available", address.toString()), e);
    }

    private static boolean isFailedToWrite(ClientException e) {
        return e.code().equals("Neo.ClientError.Cluster.NotALeader") || e.code().equals("Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }
}

