/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;

public class BufferingChunkedInput
implements PackInput {
    private static final int STACK_OVERFLOW_SUGGESTED_BUFFER_SIZE = 1400;
    private final ByteBuffer buffer;
    private final ByteBuffer scratchBuffer;
    private final ReadableByteChannel channel;
    private State state;
    private int remainingChunkSize = 0;
    private Runnable onMessageComplete = new Runnable(){

        @Override
        public void run() {
            if (BufferingChunkedInput.this.hasMoreDataUnreadInCurrentChunk()) {
                throw new ClientException("Trying to read message complete ending '00 00' while there are more data left in the message content unread: buffer [" + BytePrinter.hexInOneLine(BufferingChunkedInput.this.buffer, BufferingChunkedInput.this.buffer.position(), BufferingChunkedInput.this.buffer.remaining()) + "], unread chunk size " + BufferingChunkedInput.this.remainingChunkSize);
            }
            try {
                BufferingChunkedInput.this.readChunkSize();
                if (BufferingChunkedInput.this.remainingChunkSize != 0) {
                    throw new ClientException("Expecting message complete ending '00 00', but got " + BytePrinter.hex(ByteBuffer.allocate(2).putShort((short)BufferingChunkedInput.this.remainingChunkSize)));
                }
            }
            catch (IOException e) {
                throw new ClientException("Error while receiving message complete ending '00 00'.", e);
            }
        }
    };

    public BufferingChunkedInput(ReadableByteChannel ch) {
        this(ch, 1400);
    }

    public BufferingChunkedInput(ReadableByteChannel channel, int bufferCapacity) {
        assert (bufferCapacity >= 1);
        this.buffer = ByteBuffer.allocate(bufferCapacity).order(ByteOrder.BIG_ENDIAN);
        this.buffer.limit(0);
        this.scratchBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        this.channel = channel;
        this.state = State.AWAITING_CHUNK;
    }

    int remainingChunkSize() {
        return this.remainingChunkSize;
    }

    @Override
    public boolean hasMoreData() throws IOException {
        return this.hasMoreDataUnreadInCurrentChunk();
    }

    @Override
    public byte readByte() throws IOException {
        this.fillScratchBuffer(1);
        return this.scratchBuffer.get();
    }

    @Override
    public short readShort() throws IOException {
        this.fillScratchBuffer(2);
        return this.scratchBuffer.getShort();
    }

    @Override
    public int readInt() throws IOException {
        this.fillScratchBuffer(4);
        return this.scratchBuffer.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.fillScratchBuffer(8);
        return this.scratchBuffer.getLong();
    }

    @Override
    public double readDouble() throws IOException {
        this.fillScratchBuffer(8);
        return this.scratchBuffer.getDouble();
    }

    @Override
    public PackInput readBytes(byte[] into, int offset, int toRead) throws IOException {
        ByteBuffer dst = ByteBuffer.wrap(into, offset, toRead);
        this.read(dst);
        return this;
    }

    @Override
    public byte peekByte() throws IOException {
        this.assertOneByteInBuffer();
        return this.buffer.get(this.buffer.position());
    }

    static int getUnsignedByteFromBuffer(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    private boolean hasMoreDataUnreadInCurrentChunk() {
        return this.remainingChunkSize > 0;
    }

    public Runnable messageBoundaryHook() {
        return this.onMessageComplete;
    }

    private void fillScratchBuffer(int bytesToRead) throws IOException {
        assert (bytesToRead <= this.scratchBuffer.capacity());
        this.scratchBuffer.clear();
        this.scratchBuffer.limit(bytesToRead);
        this.read(this.scratchBuffer);
        this.scratchBuffer.flip();
    }

    private void read(ByteBuffer dst) throws IOException {
        block5: while (true) {
            switch (this.state) {
                case AWAITING_CHUNK: {
                    this.readChunkSize();
                    break;
                }
                case IN_CHUNK: {
                    int bytesToRead;
                    if (this.remainingChunkSize == 0) {
                        this.state = State.AWAITING_CHUNK;
                        break;
                    }
                    if (this.buffer.remaining() < dst.remaining()) {
                        bytesToRead = Math.min(this.buffer.remaining(), this.remainingChunkSize);
                        BufferingChunkedInput.copyBytes(this.buffer, dst, bytesToRead);
                        this.remainingChunkSize -= bytesToRead;
                        if (this.buffer.hasRemaining()) continue block5;
                        BufferingChunkedInput.readNextPacket(this.channel, this.buffer);
                        break;
                    }
                    bytesToRead = Math.min(dst.remaining(), this.remainingChunkSize);
                    BufferingChunkedInput.copyBytes(this.buffer, dst, bytesToRead);
                    this.remainingChunkSize -= bytesToRead;
                    if (dst.remaining() == 0) {
                        return;
                    }
                    this.state = State.AWAITING_CHUNK;
                    break;
                }
                case IN_HEADER: {
                    throw new IllegalStateException("Cannot read data while in progress of reading header");
                }
            }
        }
    }

    private void assertOneByteInBuffer() throws IOException {
        while (true) {
            switch (this.state) {
                case AWAITING_CHUNK: {
                    this.readChunkSize();
                    break;
                }
                case IN_CHUNK: {
                    if (this.remainingChunkSize == 0) {
                        this.state = State.AWAITING_CHUNK;
                        break;
                    }
                    if (this.buffer.remaining() == 0) {
                        BufferingChunkedInput.readNextPacket(this.channel, this.buffer);
                        break;
                    }
                    return;
                }
                case IN_HEADER: {
                    throw new IllegalStateException("Cannot read data while in progress of reading header");
                }
            }
        }
    }

    private void readChunkSize() throws IOException {
        block5: while (true) {
            switch (this.state) {
                case AWAITING_CHUNK: {
                    if (this.buffer.remaining() == 0) {
                        while (this.buffer.remaining() == 0) {
                            BufferingChunkedInput.readNextPacket(this.channel, this.buffer);
                        }
                        continue block5;
                    }
                    if (this.buffer.remaining() >= 2) {
                        this.remainingChunkSize = this.buffer.getShort() & 0xFFFF;
                        this.state = State.IN_CHUNK;
                        return;
                    }
                    int partialChunkSize = BufferingChunkedInput.getUnsignedByteFromBuffer(this.buffer);
                    this.remainingChunkSize = partialChunkSize << 8;
                    this.state = State.IN_HEADER;
                    continue block5;
                }
                case IN_CHUNK: {
                    if (this.remainingChunkSize == 0) {
                        this.state = State.AWAITING_CHUNK;
                        break;
                    }
                    throw new IllegalStateException("Chunk size has already been read");
                }
                case IN_HEADER: {
                    int partialChunkSize;
                    if (this.buffer.remaining() >= 1) {
                        partialChunkSize = this.buffer.get();
                        this.remainingChunkSize |= partialChunkSize & 0xFF;
                        this.state = State.IN_CHUNK;
                        return;
                    }
                    BufferingChunkedInput.readNextPacket(this.channel, this.buffer);
                }
            }
        }
    }

    static void readNextPacket(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        block9: {
            assert (!buffer.hasRemaining());
            try {
                buffer.clear();
                int read = channel.read(buffer);
                if (read != -1) break block9;
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new ConnectionFailureException("Connection terminated while receiving data. This can happen due to network instabilities, or due to restarts of the database.");
            }
            catch (ClosedByInterruptException e) {
                throw new ConnectionFailureException("Connection to the database was lost because someone called `interrupt()` on the driver thread waiting for a reply. This normally happens because the JVM is shutting down, but it can also happen because your application code or some framework you are using is manually interrupting the thread.");
            }
            catch (IOException e) {
                String message = e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage();
                throw new ConnectionFailureException("Unable to process request: " + message + " buffer: \n" + BytePrinter.hex(buffer), e);
            }
            finally {
                buffer.flip();
            }
        }
    }

    private static void copyBytes(ByteBuffer from, ByteBuffer to, int bytesToRead) {
        ByteBuffer temporaryBuffer = from.duplicate();
        temporaryBuffer.limit(temporaryBuffer.position() + bytesToRead);
        to.put(temporaryBuffer);
        from.position(from.position() + bytesToRead);
    }

    private static enum State {
        AWAITING_CHUNK,
        IN_CHUNK,
        IN_HEADER;

    }
}

