/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.logging.DevNullLogger;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.types.TypeSystem;

public class NetworkSession
implements Session {
    protected Connection connection;
    private final String sessionId;
    private final Logger logger;
    private String lastBookmark = null;
    private final Runnable txCleanup = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NetworkSession networkSession = NetworkSession.this;
            synchronized (networkSession) {
                if (NetworkSession.this.currentTransaction != null) {
                    NetworkSession.this.lastBookmark = NetworkSession.this.currentTransaction.bookmark();
                    NetworkSession.this.currentTransaction = null;
                }
            }
        }
    };
    private ExplicitTransaction currentTransaction;
    private AtomicBoolean isOpen = new AtomicBoolean(true);

    public NetworkSession(Connection connection) {
        this.connection = connection;
        this.logger = connection != null && connection.logger() != null ? connection.logger() : DevNullLogger.DEV_NULL_LOGGER;
        this.sessionId = UUID.randomUUID().toString();
        this.logger.debug("~~ connection claimed by [session-%s]", this.sessionId);
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        this.ensureConnectionIsValidBeforeRunningSession();
        InternalStatementResult cursor = new InternalStatementResult(this.connection, null, statement);
        this.connection.run(statement.text(), statement.parameters().asMap(Values.ofValue()), cursor.runResponseCollector());
        this.connection.pullAll(cursor.pullAllResponseCollector());
        this.connection.flush();
        return cursor;
    }

    @Override
    public synchronized void reset() {
        this.ensureSessionIsOpen();
        this.ensureNoUnrecoverableError();
        this.ensureConnectionIsOpen();
        if (this.currentTransaction != null) {
            this.currentTransaction.markToClose();
            this.lastBookmark = this.currentTransaction.bookmark();
            this.currentTransaction = null;
        }
        this.connection.resetAsync();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen.compareAndSet(true, false)) {
            throw new ClientException("This session has already been closed.");
        }
        NetworkSession networkSession = this;
        synchronized (networkSession) {
            if (this.currentTransaction != null) {
                try {
                    this.currentTransaction.close();
                }
                catch (Throwable e) {
                    this.logger.error("Failed to close tx due to error: " + e.toString(), e);
                }
            }
        }
        try {
            this.connection.sync();
        }
        catch (Throwable t) {
            try {
                this.logger.error("Failed to sync messages due to error: " + t.toString(), t);
                throw t;
            }
            catch (Throwable throwable) {
                this.logger.debug("~~ connection released by [session-%s]", this.sessionId);
                this.connection.close();
                throw throwable;
            }
        }
        this.logger.debug("~~ connection released by [session-%s]", this.sessionId);
        this.connection.close();
    }

    @Override
    public String server() {
        return this.connection.server();
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(null);
    }

    @Override
    public synchronized Transaction beginTransaction(String bookmark) {
        this.ensureConnectionIsValidBeforeOpeningTransaction();
        this.currentTransaction = new ExplicitTransaction(this.connection, this.txCleanup, bookmark);
        this.connection.onError(new Runnable(){

            @Override
            public void run() {
                if (NetworkSession.this.currentTransaction != null) {
                    if (NetworkSession.this.connection.hasUnrecoverableErrors()) {
                        NetworkSession.this.currentTransaction.markToClose();
                    } else {
                        NetworkSession.this.currentTransaction.failure();
                    }
                }
            }
        });
        return this.currentTransaction;
    }

    @Override
    public String lastBookmark() {
        return this.lastBookmark;
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    private void ensureConnectionIsValidBeforeRunningSession() {
        this.ensureSessionIsOpen();
        this.ensureNoUnrecoverableError();
        this.ensureNoOpenTransactionBeforeRunningSession();
        this.ensureConnectionIsOpen();
    }

    private void ensureConnectionIsValidBeforeOpeningTransaction() {
        this.ensureSessionIsOpen();
        this.ensureNoUnrecoverableError();
        this.ensureNoOpenTransactionBeforeOpeningTransaction();
        this.ensureConnectionIsOpen();
    }

    protected void finalize() throws Throwable {
        if (this.isOpen.compareAndSet(true, false)) {
            this.logger.error("Neo4j Session object leaked, please ensure that your application calls the `close` method on Sessions before disposing of the objects.", null);
            this.connection.close();
        }
        super.finalize();
    }

    private void ensureNoUnrecoverableError() {
        if (this.connection.hasUnrecoverableErrors()) {
            throw new ClientException("Cannot run more statements in the current session as an unrecoverable error has happened. Please close the current session and re-run your statement in a new session.");
        }
    }

    private void ensureNoOpenTransactionBeforeRunningSession() {
        if (this.currentTransaction != null) {
            throw new ClientException("Statements cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureNoOpenTransactionBeforeOpeningTransaction() {
        if (this.currentTransaction != null) {
            throw new ClientException("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureConnectionIsOpen() {
        if (!this.connection.isOpen()) {
            throw new ConnectionFailureException("The current session cannot be reused as the underlying connection with the server has been closed due to unrecoverable errors. Please close this session and retry your statement in another new session.");
        }
    }

    private void ensureSessionIsOpen() {
        if (!this.isOpen()) {
            throw new ClientException("No more interaction with this session is allowed as the current session is already closed or marked as closed. You get this error either because you have a bad reference to a session that has already be closed or you are trying to reuse a session that you have called `reset` on it.");
        }
    }
}

