/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class ConcurrentRoundRobinSet<T>
implements Set<T> {
    private final ConcurrentSkipListSet<T> set;
    private T current;

    public ConcurrentRoundRobinSet() {
        this.set = new ConcurrentSkipListSet();
    }

    public ConcurrentRoundRobinSet(Comparator<T> comparator) {
        this.set = new ConcurrentSkipListSet<T>(comparator);
    }

    public ConcurrentRoundRobinSet(ConcurrentRoundRobinSet<T> original) {
        this.set = new ConcurrentSkipListSet<T>(original.set.comparator());
        this.set.addAll(original);
    }

    public T hop() {
        if (this.current == null) {
            this.current = this.set.first();
        } else {
            this.current = this.set.higher(this.current);
            if (this.current == null) {
                this.current = this.set.first();
            }
        }
        if (this.current == null) {
            throw new IllegalStateException("nothing in the set");
        }
        return this.current;
    }

    @Override
    public boolean add(T item) {
        return this.set.add(item);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.set.toArray(a);
    }
}

