/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.ConcurrencyGuardingConnection;
import org.neo4j.driver.internal.net.SocketConnection;
import org.neo4j.driver.internal.net.pooling.PoolSettings;
import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.net.pooling.PooledConnectionReleaseConsumer;
import org.neo4j.driver.internal.net.pooling.PooledConnectionValidator;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class SocketConnectionPool
implements ConnectionPool {
    private final ConcurrentHashMap<BoltServerAddress, BlockingQueue<PooledConnection>> pools = new ConcurrentHashMap();
    private final Clock clock = Clock.SYSTEM;
    private final ConnectionSettings connectionSettings;
    private final SecurityPlan securityPlan;
    private final PoolSettings poolSettings;
    private final Logging logging;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public SocketConnectionPool(ConnectionSettings connectionSettings, SecurityPlan securityPlan, PoolSettings poolSettings, Logging logging) {
        this.connectionSettings = connectionSettings;
        this.securityPlan = securityPlan;
        this.poolSettings = poolSettings;
        this.logging = logging;
    }

    private Connection connect(BoltServerAddress address) throws ClientException {
        Connection conn = new SocketConnection(address, this.securityPlan, this.logging);
        conn = new ConcurrencyGuardingConnection(conn);
        conn.init(this.connectionSettings.userAgent(), SocketConnectionPool.tokenAsMap(this.connectionSettings.authToken()));
        return conn;
    }

    private static Map<String, Value> tokenAsMap(AuthToken token) {
        if (token instanceof InternalAuthToken) {
            return ((InternalAuthToken)token).toMap();
        }
        throw new ClientException("Unknown authentication token, `" + token + "`. Please use one of the supported " + "tokens from `" + AuthTokens.class.getSimpleName() + "`.");
    }

    @Override
    public Connection acquire(BoltServerAddress address) {
        if (this.stopped.get()) {
            throw new IllegalStateException("Pool has been closed, cannot acquire new values.");
        }
        BlockingQueue<PooledConnection> connections = this.pool(address);
        PooledConnection conn = (PooledConnection)connections.poll();
        if (conn == null) {
            conn = new PooledConnection(this.connect(address), new PooledConnectionReleaseConsumer(connections, this.stopped, new PooledConnectionValidator(this, this.poolSettings)), this.clock);
        }
        conn.updateUsageTimestamp();
        return conn;
    }

    private BlockingQueue<PooledConnection> pool(BoltServerAddress address) {
        BlockingQueue<PooledConnection> pool = this.pools.get(address);
        if (pool == null && this.pools.putIfAbsent(address, pool = new LinkedBlockingQueue<PooledConnection>(this.poolSettings.maxIdleConnectionPoolSize())) != null) {
            return this.pool(address);
        }
        return pool;
    }

    @Override
    public void purge(BoltServerAddress address) {
        BlockingQueue<PooledConnection> connections = this.pools.remove(address);
        if (connections == null) {
            return;
        }
        while (!connections.isEmpty()) {
            PooledConnection connection = (PooledConnection)connections.poll();
            if (connection == null) continue;
            connection.dispose();
        }
    }

    @Override
    public boolean hasAddress(BoltServerAddress address) {
        return this.pools.containsKey(address);
    }

    @Override
    public void close() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        for (BlockingQueue<PooledConnection> pool : this.pools.values()) {
            while (!pool.isEmpty()) {
                PooledConnection conn = (PooledConnection)pool.poll();
                if (conn == null) continue;
                conn.dispose();
            }
        }
        this.pools.clear();
    }
}

