/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import org.neo4j.driver.v1.summary.SummaryCounters;

public class InternalSummaryCounters
implements SummaryCounters {
    public static final InternalSummaryCounters EMPTY_STATS = new InternalSummaryCounters(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    private final int nodesCreated;
    private final int nodesDeleted;
    private final int relationshipsCreated;
    private final int relationshipsDeleted;
    private final int propertiesSet;
    private final int labelsAdded;
    private final int labelsRemoved;
    private final int indexesAdded;
    private final int indexesRemoved;
    private final int constraintsAdded;
    private final int constrainsRemoved;

    public InternalSummaryCounters(int nodesCreated, int nodesDeleted, int relationshipsCreated, int relationshipsDeleted, int propertiesSet, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constrainsRemoved) {
        this.nodesCreated = nodesCreated;
        this.nodesDeleted = nodesDeleted;
        this.relationshipsCreated = relationshipsCreated;
        this.relationshipsDeleted = relationshipsDeleted;
        this.propertiesSet = propertiesSet;
        this.labelsAdded = labelsAdded;
        this.labelsRemoved = labelsRemoved;
        this.indexesAdded = indexesAdded;
        this.indexesRemoved = indexesRemoved;
        this.constraintsAdded = constraintsAdded;
        this.constrainsRemoved = constrainsRemoved;
    }

    @Override
    public boolean containsUpdates() {
        return this.isPositive(this.nodesCreated) || this.isPositive(this.nodesDeleted) || this.isPositive(this.relationshipsCreated) || this.isPositive(this.relationshipsDeleted) || this.isPositive(this.propertiesSet) || this.isPositive(this.labelsAdded) || this.isPositive(this.labelsRemoved) || this.isPositive(this.indexesAdded) || this.isPositive(this.indexesRemoved) || this.isPositive(this.constraintsAdded) || this.isPositive(this.constrainsRemoved);
    }

    @Override
    public int nodesCreated() {
        return this.nodesCreated;
    }

    @Override
    public int nodesDeleted() {
        return this.nodesDeleted;
    }

    @Override
    public int relationshipsCreated() {
        return this.relationshipsCreated;
    }

    @Override
    public int relationshipsDeleted() {
        return this.relationshipsDeleted;
    }

    @Override
    public int propertiesSet() {
        return this.propertiesSet;
    }

    @Override
    public int labelsAdded() {
        return this.labelsAdded;
    }

    @Override
    public int labelsRemoved() {
        return this.labelsRemoved;
    }

    @Override
    public int indexesAdded() {
        return this.indexesAdded;
    }

    @Override
    public int indexesRemoved() {
        return this.indexesRemoved;
    }

    @Override
    public int constraintsAdded() {
        return this.constraintsAdded;
    }

    @Override
    public int constraintsRemoved() {
        return this.constrainsRemoved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalSummaryCounters that = (InternalSummaryCounters)o;
        return this.nodesCreated == that.nodesCreated && this.nodesDeleted == that.nodesDeleted && this.relationshipsCreated == that.relationshipsCreated && this.relationshipsDeleted == that.relationshipsDeleted && this.propertiesSet == that.propertiesSet && this.labelsAdded == that.labelsAdded && this.labelsRemoved == that.labelsRemoved && this.indexesAdded == that.indexesAdded && this.indexesRemoved == that.indexesRemoved && this.constraintsAdded == that.constraintsAdded && this.constrainsRemoved == that.constrainsRemoved;
    }

    public int hashCode() {
        int result = this.nodesCreated;
        result = 31 * result + this.nodesDeleted;
        result = 31 * result + this.relationshipsCreated;
        result = 31 * result + this.relationshipsDeleted;
        result = 31 * result + this.propertiesSet;
        result = 31 * result + this.labelsAdded;
        result = 31 * result + this.labelsRemoved;
        result = 31 * result + this.indexesAdded;
        result = 31 * result + this.indexesRemoved;
        result = 31 * result + this.constraintsAdded;
        result = 31 * result + this.constrainsRemoved;
        return result;
    }

    private boolean isPositive(int value) {
        return value > 0;
    }
}

