/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.internal.util.CertificateTool;
import org.neo4j.driver.v1.Logger;

public class TrustOnFirstUseTrustManager
implements X509TrustManager {
    private final File knownHosts;
    private final String serverId;
    private final Logger logger;
    private String fingerprint;

    TrustOnFirstUseTrustManager(String host, int port, File knownHosts, Logger logger) throws IOException {
        this.logger = logger;
        this.serverId = host + ":" + port;
        this.knownHosts = knownHosts;
        this.load();
    }

    private void load() throws IOException {
        String line;
        if (!this.knownHosts.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.knownHosts));
        while ((line = reader.readLine()) != null) {
            String[] strings;
            if (line.trim().startsWith("#") || !(strings = line.split(" "))[0].trim().equals(this.serverId)) continue;
            this.fingerprint = strings[1].trim();
            return;
        }
        reader.close();
    }

    private void saveTrustedHost(String fingerprint) throws IOException {
        this.fingerprint = fingerprint;
        this.logger.warn("Adding %s as known and trusted certificate for %s.", fingerprint, this.serverId);
        this.createKnownCertFileIfNotExists();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.knownHosts, true));
        writer.write(this.serverId + " " + this.fingerprint);
        writer.newLine();
        writer.close();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException("All client connections to this client are forbidden.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate certificate = chain[0];
        String cert = TrustOnFirstUseTrustManager.fingerprint(certificate);
        if (this.fingerprint == null) {
            try {
                this.saveTrustedHost(cert);
            }
            catch (IOException e) {
                throw new CertificateException(String.format("Failed to save the server ID and the certificate received from the server to file %s.\nServer ID: %s\nReceived cert:\n%s", this.knownHosts.getAbsolutePath(), this.serverId, CertificateTool.X509CertToString(cert)), e);
            }
        } else if (!this.fingerprint.equals(cert)) {
            throw new CertificateException(String.format("Unable to connect to neo4j at `%s`, because the certificate the server uses has changed. This is a security feature to protect against man-in-the-middle attacks.\nIf you trust the certificate the server uses now, simply remove the line that starts with `%s` in the file `%s`.\nThe old certificate saved in file is:\n%sThe New certificate received is:\n%s", this.serverId, this.serverId, this.knownHosts.getAbsolutePath(), CertificateTool.X509CertToString(this.fingerprint), CertificateTool.X509CertToString(cert)));
        }
    }

    public static String fingerprint(X509Certificate cert) throws CertificateException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(cert.getEncoded());
            return BytePrinter.compactHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException("Cannot use TLS on this platform, because SHA-512 message digest algorithm is not available: " + e.getMessage(), e);
        }
    }

    private File createKnownCertFileIfNotExists() throws IOException {
        if (!this.knownHosts.exists()) {
            File parentDir = this.knownHosts.getParentFile();
            try {
                if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                    throw new IOException("Failed to create directories for the known hosts file in " + this.knownHosts.getAbsolutePath() + ". This is usually because you do not have write permissions to the directory. " + "Try configuring the Neo4j driver to use a file system location you do have write permissions to.");
                }
                if (!this.knownHosts.createNewFile()) {
                    throw new IOException("Failed to create a known hosts file at " + this.knownHosts.getAbsolutePath() + ". This is usually because you do not have write permissions to the directory. " + "Try configuring the Neo4j driver to use a file system location you do have write permissions to.");
                }
            }
            catch (SecurityException e) {
                throw new IOException("Failed to create known host file and/or parent directories at " + this.knownHosts.getAbsolutePath() + ". This is usually because you do not have write permission to the directory. " + "Try configuring the Neo4j driver to use a file location you have write permissions to.");
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.knownHosts));
            writer.write("# This file contains trusted certificates for Neo4j servers, it's created by Neo4j drivers.");
            writer.newLine();
            writer.write("# You can configure the location of this file in `org.neo4j.driver.Config`");
            writer.newLine();
            writer.close();
        }
        return this.knownHosts;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

