/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.pool.PooledConnection;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Value;

class PooledConnectionReleaseConsumer
implements Consumer<PooledConnection> {
    private final BlockingQueue<PooledConnection> connections;
    private final long minIdleBeforeConnectionTest;
    private static final Map<String, Value> NO_PARAMETERS = new HashMap<String, Value>();
    private final AtomicBoolean driverStopped;

    PooledConnectionReleaseConsumer(BlockingQueue<PooledConnection> connections, AtomicBoolean driverStopped, Config config) {
        this.connections = connections;
        this.driverStopped = driverStopped;
        this.minIdleBeforeConnectionTest = config.idleTimeBeforeConnectionTest();
    }

    @Override
    public void accept(PooledConnection pooledConnection) {
        if (this.driverStopped.get()) {
            pooledConnection.dispose();
        } else if (this.validConnection(pooledConnection)) {
            PooledConnection conn;
            boolean released = this.connections.offer(pooledConnection);
            if (!released) {
                pooledConnection.dispose();
            } else if (this.driverStopped.get() && (conn = (PooledConnection)this.connections.poll()) != null) {
                conn.dispose();
            }
        } else {
            pooledConnection.dispose();
        }
    }

    boolean validConnection(PooledConnection pooledConnection) {
        return !pooledConnection.hasUnrecoverableErrors() && this.reset(pooledConnection) && (pooledConnection.idleTime() <= this.minIdleBeforeConnectionTest || this.ping(pooledConnection));
    }

    private boolean reset(PooledConnection conn) {
        try {
            conn.reset();
            conn.sync();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean ping(PooledConnection conn) {
        try {
            conn.run("RETURN 1 // JavaDriver poll to test connection", NO_PARAMETERS, StreamCollector.NO_OP);
            conn.pullAll(StreamCollector.NO_OP);
            conn.sync();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

