/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pool;

import java.util.Map;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class PooledConnection
implements Connection {
    private final Connection delegate;
    private final Consumer<PooledConnection> release;
    private boolean unrecoverableErrorsOccurred = false;
    private Runnable onError = null;
    private final Clock clock;
    private long lastUsed;

    public PooledConnection(Connection delegate, Consumer<PooledConnection> release, Clock clock) {
        this.delegate = delegate;
        this.release = release;
        this.clock = clock;
        this.lastUsed = clock.millis();
    }

    public void updateUsageTimestamp() {
        this.lastUsed = this.clock.millis();
    }

    @Override
    public void init(String clientName, Map<String, Value> authToken) {
        try {
            this.delegate.init(clientName, authToken);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, StreamCollector collector) {
        try {
            this.delegate.run(statement, parameters, collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void discardAll() {
        try {
            this.delegate.discardAll();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void pullAll(StreamCollector collector) {
        try {
            this.delegate.pullAll(collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void reset() {
        try {
            this.delegate.reset();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void ackFailure() {
        try {
            this.delegate.ackFailure();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void sync() {
        try {
            this.delegate.sync();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.delegate.flush();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void receiveOne() {
        try {
            this.delegate.receiveOne();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void close() {
        this.release.accept(this);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean hasUnrecoverableErrors() {
        return this.unrecoverableErrorsOccurred;
    }

    public void dispose() {
        this.delegate.close();
    }

    private void onDelegateException(RuntimeException e) {
        if (this.isUnrecoverableErrorsOccurred(e)) {
            this.unrecoverableErrorsOccurred = true;
            if (this.isClusterError(e)) {
                e = new ClientException(String.format("Failed to run a statement on a 3.1+ Neo4j core-edge cluster server. %nPlease retry the statement if you have defined your own routing strategy to route driver messages to the cluster. Note: 1.0 java driver does not support routing statements to a 3.1+ Neo4j core edge cluster. Please upgrade to 1.1 driver and use `bolt+routing` scheme to route and run statements directly to a 3.1+ core edge cluster.", new Object[0]), e);
            }
        } else {
            this.ackFailure();
        }
        if (this.onError != null) {
            this.onError.run();
        }
        throw e;
    }

    @Override
    public void onError(Runnable runnable) {
        this.onError = runnable;
    }

    private boolean isUnrecoverableErrorsOccurred(RuntimeException e) {
        return !this.isClientOrTransientError(e) || this.isProtocolViolationError(e) || this.isClusterError(e);
    }

    private boolean isProtocolViolationError(RuntimeException e) {
        return e instanceof Neo4jException && ((Neo4jException)e).neo4jErrorCode().startsWith("Neo.ClientError.Request");
    }

    private boolean isClientOrTransientError(RuntimeException e) {
        return e instanceof Neo4jException && ((Neo4jException)e).neo4jErrorCode().contains("ClientError") || e instanceof Neo4jException && ((Neo4jException)e).neo4jErrorCode().contains("TransientError");
    }

    private boolean isClusterError(RuntimeException e) {
        return e instanceof Neo4jException && ((Neo4jException)e).neo4jErrorCode().contains("Cluster");
    }

    public long idleTime() {
        long idleTime = this.clock.millis() - this.lastUsed;
        return idleTime;
    }
}

