/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.TypeSystem;

public class InternalSession
implements Session {
    private final Connection connection;
    private final Logger logger;
    private final Runnable txCleanup = new Runnable(){

        @Override
        public void run() {
            InternalSession.this.currentTransaction = null;
        }
    };
    private InternalTransaction currentTransaction;
    private AtomicBoolean isOpen = new AtomicBoolean(true);

    public InternalSession(Connection connection, Logger logger) {
        this.connection = connection;
        this.logger = logger;
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        this.ensureConnectionIsValidBeforeRunningSession();
        InternalStatementResult cursor = new InternalStatementResult(this.connection, statement);
        this.connection.run(statement.text(), statement.parameters().asMap(Values.ofValue()), cursor.runResponseCollector());
        this.connection.pullAll(cursor.pullAllResponseCollector());
        this.connection.flush();
        return cursor;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen.compareAndSet(true, false)) {
            throw new ClientException("This session has already been closed.");
        }
        if (!this.connection.isOpen()) {
            this.connection.close();
            return;
        }
        if (this.currentTransaction != null) {
            try {
                this.currentTransaction.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.connection.sync();
        }
        finally {
            this.connection.close();
        }
    }

    @Override
    public Transaction beginTransaction() {
        this.ensureConnectionIsValidBeforeOpeningTransaction();
        this.currentTransaction = new InternalTransaction(this.connection, this.txCleanup);
        this.connection.onError(new Runnable(){

            @Override
            public void run() {
                if (InternalSession.this.currentTransaction != null) {
                    if (InternalSession.this.connection.hasUnrecoverableErrors()) {
                        InternalSession.this.currentTransaction.markToClose();
                    } else {
                        InternalSession.this.currentTransaction.failure();
                    }
                }
            }
        });
        return this.currentTransaction;
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    private void ensureConnectionIsValidBeforeRunningSession() {
        this.ensureNoUnrecoverableError();
        this.ensureNoOpenTransactionBeforeRunningSession();
        this.ensureConnectionIsOpen();
    }

    private void ensureConnectionIsValidBeforeOpeningTransaction() {
        this.ensureNoUnrecoverableError();
        this.ensureNoOpenTransactionBeforeOpeningTransaction();
        this.ensureConnectionIsOpen();
    }

    protected void finalize() throws Throwable {
        if (this.isOpen.compareAndSet(true, false)) {
            this.logger.error("Neo4j Session object leaked, please ensure that your application calls the `close` method on Sessions before disposing of the objects.", null);
            this.connection.close();
        }
        super.finalize();
    }

    private void ensureNoUnrecoverableError() {
        if (this.connection.hasUnrecoverableErrors()) {
            throw new ClientException("Cannot run more statements in the current session as an unrecoverable error has happened. Please close the current session and re-run your statement in a new session.");
        }
    }

    private void ensureNoOpenTransactionBeforeRunningSession() {
        if (this.currentTransaction != null) {
            throw new ClientException("Statements cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureNoOpenTransactionBeforeOpeningTransaction() {
        if (this.currentTransaction != null) {
            throw new ClientException("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureConnectionIsOpen() {
        if (!this.connection.isOpen()) {
            throw new ClientException("The current session cannot be reused as the underlying connection with the server has been closed due to unrecoverable errors. Please close this session and retry your statement in another new session.");
        }
    }
}

