/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.net.URI;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;

public class GraphDatabase {
    public static Driver driver(String url) {
        return GraphDatabase.driver(url, Config.defaultConfig());
    }

    public static Driver driver(URI url) {
        return GraphDatabase.driver(url, Config.defaultConfig());
    }

    public static Driver driver(URI url, Config config) {
        return GraphDatabase.driver(url, AuthTokens.none(), config);
    }

    public static Driver driver(String url, Config config) {
        return GraphDatabase.driver(URI.create(url), config);
    }

    public static Driver driver(String url, AuthToken authToken) {
        return GraphDatabase.driver(url, authToken, Config.defaultConfig());
    }

    public static Driver driver(URI url, AuthToken authToken) {
        return GraphDatabase.driver(url, authToken, Config.defaultConfig());
    }

    public static Driver driver(String url, AuthToken authToken, Config config) {
        return GraphDatabase.driver(URI.create(url), authToken, config);
    }

    public static Driver driver(URI url, AuthToken authToken, Config config) {
        AuthToken tokenToUse = authToken != null ? authToken : AuthTokens.none();
        Config configToUse = config != null ? config : Config.defaultConfig();
        return new InternalDriver(url, tokenToUse, configToUse);
    }
}

