/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pool;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.driver.internal.pool.ValidationStrategy;
import org.neo4j.driver.internal.util.Clock;

class Slot<T> {
    final AtomicReference<State> state = new AtomicReference<State>(State.CLAIMED);
    final int index;
    final Clock clock;
    long lastUsed;
    T value;

    Slot(int index, Clock clock) {
        this.index = index;
        this.clock = clock;
        this.lastUsed = 0L;
    }

    public void set(T value) {
        this.value = value;
    }

    public boolean availableToClaimed() {
        return this.state.compareAndSet(State.AVAILABLE, State.CLAIMED);
    }

    public boolean availableToThreadLocalClaimed() {
        return this.state.compareAndSet(State.AVAILABLE, State.THREAD_LOCAL_CLAIMED);
    }

    public boolean claimedToAvailable() {
        this.updateUsageTimestamp();
        return this.state.compareAndSet(State.CLAIMED, State.AVAILABLE);
    }

    public boolean claimedToDisposed() {
        return this.state.compareAndSet(State.CLAIMED, State.DISPOSED);
    }

    public boolean threadLocalClaimedToDisposed() {
        return this.state.compareAndSet(State.THREAD_LOCAL_CLAIMED, State.DISPOSED);
    }

    public boolean threadLocalClaimedToClaimed() {
        return this.state.compareAndSet(State.THREAD_LOCAL_CLAIMED, State.CLAIMED);
    }

    public boolean threadLocalClaimedToAvailable() {
        return this.state.compareAndSet(State.THREAD_LOCAL_CLAIMED, State.AVAILABLE);
    }

    public void claimByThreadLocal() {
        this.state.set(State.THREAD_LOCAL_CLAIMED);
    }

    public boolean isClaimedOrAvailableToClaimed() {
        return this.availableToClaimed() || this.state.get() == State.CLAIMED;
    }

    public boolean disposed() {
        return this.state.get() == State.DISPOSED;
    }

    public void updateUsageTimestamp() {
        this.lastUsed = this.clock.millis();
    }

    boolean isValid(ValidationStrategy<T> strategy) {
        return strategy.isValid(this.value, this.clock.millis() - this.lastUsed);
    }

    public String toString() {
        return "Slot{value=" + this.value + ", lastUsed=" + this.lastUsed + ", index=" + this.index + ", state=" + (Object)((Object)this.state.get()) + '}';
    }

    static enum State {
        AVAILABLE,
        THREAD_LOCAL_CLAIMED,
        CLAIMED,
        DISPOSED;

    }
}

