/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class ConcurrencyGuardingConnection
implements Connection {
    private final Connection delegate;
    private final AtomicBoolean inUse = new AtomicBoolean(false);

    public ConcurrencyGuardingConnection(Connection delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String clientName, Map<String, Value> authToken) {
        try {
            this.markAsInUse();
            this.delegate.init(clientName, authToken);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String statement, Map<String, Value> parameters, StreamCollector collector) {
        try {
            this.markAsInUse();
            this.delegate.run(statement, parameters, collector);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardAll() {
        try {
            this.markAsInUse();
            this.delegate.discardAll();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullAll(StreamCollector collector) {
        try {
            this.markAsInUse();
            this.delegate.pullAll(collector);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(StreamCollector collector) {
        try {
            this.markAsInUse();
            this.delegate.reset(collector);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        try {
            this.markAsInUse();
            this.delegate.sync();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            this.markAsInUse();
            this.delegate.flush();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveOne() {
        try {
            this.markAsInUse();
            this.delegate.receiveOne();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.markAsInUse();
            this.delegate.close();
        }
        finally {
            this.markAsAvailable();
        }
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void onError(Runnable runnable) {
        this.delegate.onError(runnable);
    }

    private void markAsAvailable() {
        this.inUse.set(false);
    }

    private void markAsInUse() {
        if (!this.inUse.compareAndSet(false, true)) {
            throw new ClientException("You are using a session from multiple locations at the same time, which is not supported. If you want to use multiple threads, you should ensure that each session is used by only one thread at a time. One way to do that is to give each thread its own dedicated session.");
        }
    }
}

