/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ScalarValueAdapter;
import org.neo4j.driver.v1.Type;

public class StringValue
extends ScalarValueAdapter {
    private final String val;

    public StringValue(String val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot construct StringValue from null");
        }
        this.val = val;
    }

    @Override
    public boolean isEmpty() {
        return this.val.isEmpty();
    }

    @Override
    public int size() {
        return this.val.length();
    }

    @Override
    public String asObject() {
        return this.asString();
    }

    @Override
    public String asString() {
        return this.val;
    }

    @Override
    public String asLiteralString() {
        return String.format("\"%s\"", this.val.replace("\"", "\\\""));
    }

    @Override
    public Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.STRING();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue values = (StringValue)o;
        return this.val == values.val || this.val.equals(values.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }
}

