/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.neo4j.driver.internal.util.CertificateTool;

class TrustOnFirstUseTrustManager
implements X509TrustManager {
    private final File knownCerts;
    private final String serverId;
    private String cert;

    TrustOnFirstUseTrustManager(String host, int port, File knownCerts) throws IOException {
        String ip = InetAddress.getByName(host).getHostAddress();
        this.serverId = ip + ":" + port;
        this.knownCerts = knownCerts;
        this.load();
    }

    private void load() throws IOException {
        if (!this.knownCerts.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.knownCerts));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] strings;
            if (line.trim().startsWith("#") || !line.contains(",") || !(strings = line.split(","))[0].trim().equals(this.serverId)) continue;
            this.cert = strings[1].trim();
            return;
        }
        reader.close();
    }

    private void save(String cert) throws IOException {
        this.cert = cert;
        this.createKnownCertFileIfNotExists();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.knownCerts, true));
        writer.write(this.serverId + "," + this.cert);
        writer.newLine();
        writer.close();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException("All client connections to this client are forbidden.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate certificate = chain[0];
        byte[] encoded = certificate.getEncoded();
        String cert = DatatypeConverter.printBase64Binary((byte[])encoded);
        if (this.cert == null) {
            try {
                this.save(cert);
            }
            catch (IOException e) {
                throw new CertificateException(String.format("Failed to save the server ID and the certificate received from the server to file %s.\nServer ID: %s\nReceived cert:\n%s", this.knownCerts.getAbsolutePath(), this.serverId, CertificateTool.X509CertToString(cert)), e);
            }
        } else if (!this.cert.equals(cert)) {
            throw new CertificateException(String.format("Unable to connect to neo4j at `%s`, because the certificate the server uses has changed. This is a security feature to protect against man-in-the-middle attacks.\nIf you trust the certificate the server uses now, simply remove the line that starts with `%s` in the file `%s`.\nThe old certificate saved in file is:\n%sThe New certificate received is:\n%s", this.serverId, this.serverId, this.knownCerts.getAbsolutePath(), CertificateTool.X509CertToString(this.cert), CertificateTool.X509CertToString(cert)));
        }
    }

    private File createKnownCertFileIfNotExists() throws IOException {
        if (!this.knownCerts.exists()) {
            File parentDir = this.knownCerts.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            this.knownCerts.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.knownCerts));
            writer.write("# This file contains trusted certificates for Neo4j servers, it's created by Neo4j drivers.");
            writer.newLine();
            writer.write("# You can configure the location of this file in `org.neo4j.driver.Config`");
            writer.newLine();
            writer.close();
        }
        return this.knownCerts;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

