/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.Logger;
import org.neo4j.driver.internal.summary.ResultBuilder;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.ResultCursor;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TypeSystem;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class InternalSession
implements Session {
    private final Connection connection;
    private final Logger logger;
    private final Runnable txCleanup = new Runnable(){

        @Override
        public void run() {
            InternalSession.this.currentTransaction = null;
        }
    };
    private Transaction currentTransaction;
    private boolean isOpen = true;

    public InternalSession(Connection connection, Logger logger) {
        this.connection = connection;
        this.logger = logger;
    }

    @Override
    public ResultCursor run(String statementText, Map<String, Value> statementParameters) {
        this.ensureConnectionIsValid();
        ResultBuilder resultBuilder = new ResultBuilder(statementText, statementParameters);
        this.connection.run(statementText, statementParameters, resultBuilder);
        this.connection.pullAll(resultBuilder);
        this.connection.sync();
        return resultBuilder.build();
    }

    @Override
    public ResultCursor run(String statementTemplate) {
        return this.run(statementTemplate, ParameterSupport.NO_PARAMETERS);
    }

    @Override
    public ResultCursor run(Statement statement) {
        return this.run(statement.template(), statement.parameters());
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new ClientException("This session has already been closed.");
        }
        this.isOpen = false;
        if (this.currentTransaction != null) {
            try {
                this.currentTransaction.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.connection.close();
    }

    @Override
    public Transaction beginTransaction() {
        this.ensureConnectionIsValid();
        this.currentTransaction = new InternalTransaction(this.connection, this.txCleanup);
        return this.currentTransaction;
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    private void ensureConnectionIsValid() {
        this.ensureNoOpenTransaction();
        this.ensureConnectionIsOpen();
    }

    protected void finalize() throws Throwable {
        if (this.isOpen) {
            this.logger.error("Neo4j Session object leaked, please ensure that your application calls the `close` method on Sessions before disposing of the objects.", null);
            this.connection.close();
        }
        super.finalize();
    }

    private void ensureNoOpenTransaction() {
        if (this.currentTransaction != null) {
            throw new ClientException("Please close the currently open transaction object before running more statements/transactions in the current session.");
        }
    }

    private void ensureConnectionIsOpen() {
        if (!this.connection.isOpen()) {
            throw new ClientException("The current session cannot be reused as the underlying connection with the server has been closed due to unrecoverable errors. Please close this session and retry your statement in another new session.");
        }
    }
}

