/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Format;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.ValueAdapter;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.Type;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public class ListValue
extends ValueAdapter {
    private final Value[] values;

    public ListValue(Value ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Cannot construct ListValue from null");
        }
        this.values = values;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public List<Object> asObject() {
        return this.asList(Values.valueAsObject());
    }

    @Override
    public List<Value> asList() {
        return Extract.list(this.values);
    }

    @Override
    public <T> List<T> asList(Function<Value, T> mapFunction) {
        return Extract.list(this.values, mapFunction);
    }

    @Override
    public Value[] asArray() {
        int size = this.size();
        Value[] result = new Value[size];
        System.arraycopy(this.values, 0, result, 0, size);
        return result;
    }

    @Override
    public <T> T[] asArray(Class<T> clazz, Function<Value, T> mapFunction) {
        int size = this.size();
        Object[] result = (Object[])Array.newInstance(clazz, size);
        for (int i = 0; i < size; ++i) {
            result[i] = mapFunction.apply(this.values[i]);
        }
        return result;
    }

    @Override
    public long[] asLongArray() {
        long[] result = new long[this.size()];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i].asLong();
        }
        return result;
    }

    @Override
    public int[] asIntArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i].asInt();
        }
        return result;
    }

    @Override
    public short[] asShortArray() {
        short[] result = new short[this.size()];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i].asShort();
        }
        return result;
    }

    @Override
    public byte[] asByteArray() {
        byte[] result = new byte[this.size()];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i].asByte();
        }
        return result;
    }

    @Override
    public double[] asDoubleArray() {
        double[] result = new double[this.size()];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i].asDouble();
        }
        return result;
    }

    @Override
    public float[] asFloatArray() {
        float[] result = new float[this.size()];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i].asFloat();
        }
        return result;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Value value(int index) {
        return index >= 0 && index < this.values.length ? this.values[index] : Values.NULL;
    }

    @Override
    public <T> Iterable<T> values(final Function<Value, T> mapFunction) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int cursor = 0;

                    @Override
                    public boolean hasNext() {
                        return this.cursor < ListValue.this.values.length;
                    }

                    @Override
                    public T next() {
                        return mapFunction.apply(ListValue.this.values[this.cursor++]);
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public String asLiteralString() {
        return this.toString(InternalValue.Format.VALUE_ONLY);
    }

    @Override
    public Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.LIST();
    }

    @Override
    public String toString(InternalValue.Format valueFormat) {
        return this.maybeWithType(valueFormat.includeType(), Format.formatElements(valueFormat.inner(), this.values));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValue otherValues = (ListValue)o;
        return Arrays.equals(this.values, otherValues.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

