/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.driver.internal.connector.socket.TrustOnFirstUseTrustManager;
import org.neo4j.driver.internal.util.CertificateTool;
import org.neo4j.driver.v1.Config;

class SSLContextFactory {
    private final String host;
    private final int port;
    private final Config.TlsAuthenticationConfig authConfig;

    SSLContextFactory(String host, int port, Config.TlsAuthenticationConfig authConfig) {
        this.host = host;
        this.port = port;
        this.authConfig = authConfig;
    }

    public SSLContext create() throws GeneralSecurityException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = new KeyManager[]{};
        TrustManager[] trustManagers = null;
        if (this.authConfig.isFullAuthEnabled()) {
            KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
            trustedKeyStore.load(null, null);
            CertificateTool.loadX509Cert(this.authConfig.certFile(), trustedKeyStore);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustedKeyStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            trustManagers = new TrustManager[]{new TrustOnFirstUseTrustManager(this.host, this.port, this.authConfig.certFile())};
        }
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }
}

