/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.ResultBuilder;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.ResultCursor;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TypeSystem;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class InternalSession
implements Session {
    private final Connection connection;
    private final Runnable txCleanup = new Runnable(){

        @Override
        public void run() {
            InternalSession.this.currentTransaction = null;
        }
    };
    private Transaction currentTransaction;
    private boolean isOpen = true;

    public InternalSession(Connection connection) {
        this.connection = connection;
    }

    @Override
    public ResultCursor run(String statementText, Map<String, Value> statementParameters) {
        this.ensureNoOpenTransaction();
        ResultBuilder resultBuilder = new ResultBuilder(statementText, statementParameters);
        this.connection.run(statementText, statementParameters, resultBuilder);
        this.connection.pullAll(resultBuilder);
        this.connection.sync();
        return resultBuilder.build();
    }

    @Override
    public ResultCursor run(String statementTemplate) {
        return this.run(statementTemplate, ParameterSupport.NO_PARAMETERS);
    }

    @Override
    public ResultCursor run(Statement statement) {
        return this.run(statement.template(), statement.parameters());
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new ClientException("This session has already been closed.");
        }
        this.isOpen = false;
        if (this.currentTransaction != null) {
            try {
                this.currentTransaction.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.connection.close();
    }

    @Override
    public Transaction beginTransaction() {
        this.ensureNoOpenTransaction();
        this.currentTransaction = new InternalTransaction(this.connection, this.txCleanup);
        return this.currentTransaction;
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    private void ensureNoOpenTransaction() {
        if (this.currentTransaction != null) {
            throw new ClientException("Please close the currently open transaction object before running more statements/transactions in the current session.");
        }
    }
}

